P4M40.R GISS Model E  2004 modelE                     rar     07/15/2009
!! P4qsM20.R GISS Model E  2004 modelE 65m q-flux ocn      rar     07/15/2009

!! P4qsM20: P4M40 with 65m q-flux ocean ("!!"-lines are for P4qsM20.R)
P4M40: modelE as frozen in July 2009 without gravity wave drag
modelE 4x5 hor. grid with 40 lyrs, top at .1 mb (+ 3 rad.lyrs)
atmospheric composition from year 1850
ocean data: prescribed, 1876-1885 climatology  (see OSST/SICE)
uses turbulence scheme, simple strat.drag (not grav.wave drag)
time steps: dynamics 7.5 min leap frog; physics 30 min.; radiation 2.5 hrs
filters: U,V in E-W and N-S direction (after every physics time step)
         U,V in E-W direction near poles (after every dynamics time step)
         sea level pressure (after every physics time step)
radiation: GISS

Preprocessor Options
!#define TRACERS_ON                  ! include tracers code
#define USE_ENT
#define NEW_IO
#define PLANET_PARAMS notEarth       ! define to avoid tropwmo warnings about tropopause
End Preprocessor Options

Object modules
     ! resolution-specific source codes
Atm72x46                          ! horizontal resolution is 72x46 -> 4x5deg
AtmL40p STRAT_DUM                  ! vertical resolution is 40 layers -> 0.1mb
DIAG_RES_M                          ! diagnostics
FFT72                               ! Fast Fourier Transform

IO_DRV                              ! new i/o

     ! GISS dynamics without gravity wave drag
ATMDYN MOMEN2ND                     ! atmospheric dynamics
QUS_DRV TQUS_DRV                    ! advection of Q/tracers

#include "latlon_source_files"
#include "planet_source_files"
#include "static_ocn_source_files"

Components:
#include "E4_components_nc"    /* without "Ent" */
Ent

Component Options:
OPTS_Ent = ONLINE=YES PS_MODEL=FBB    /* needed for "Ent" only */
OPTS_giss_LSM = USE_ENT=YES           /* needed for "Ent" only */

Data input files:
#include "IC_72x46_planet_input_files"
#include "static_ocn_1880_144x90_planet_input_files"

RVR=RD_modelE_M.nc                ! river direction file
NAMERVR=RD_modelE_M.names.txt     ! named river outlets

#include "land72x46_planet_input_files"
#include "rad_input_files_planet_giss"
#include "planet_rad_72x46_input_files"

MSU_wts=MSU.RSS.weights.data      ! MSU-diag
REG=REG4X5                        ! special regions-diag

Label and Namelist:
P4M40 (ModelE1 4x5, 40 lyrs, 1850 atm/ocn)

&&PARAMETERS
#include "static_ocn_params"
#include "sdragF40_params"

cond_scheme=2   ! newer conductance scheme (N. Kiang) ! not used with Ent

! tuning param.: this setting works for 1850; use U00wtrX=1.28 for 1979
! Tuning parameters as of 2016/10/05 (D.S. Amundsen)
U00a=.50    ! above 850mb w/o MC region; tune this first to get 30-35% high clouds
U00b=0.55   ! below 850mb and MC regions; then tune this to get rad.balance
radiusl_multiplier=0.8
radiusi_multiplier=0.8

l_uniform_ghg=1 ! deactivates prescribed GHG distributions
CO2X=1.
O3X=0. ! turn of O3, to turn on delete this line and add O3file
H2OstratX=1.

! Cloud inhomogeneity correction
KCLDEP=1    ! use a constant value for CLDEPS
EPSCON=0.12 ! use CLDEPS=0.12

xCDpbl=1.
wsn_max=2.   ! restrict snow depth to 2 m-h2o (if 0. snow depth is NOT restricted)
KSIALB=0        ! 6-band albedo (Hansen) (=-1 no land ice fixup, 1 Lacis' scheme)

PTLISO=15.       ! press(mb) above which rad. assumes isothermal layers
H2ObyCH4=0.      ! deactivates strat.H2O generated by CH4
KSOLAR=2         ! 2: use long annual mean file ; 1: use short monthly file

#include "planet_atmCompos_1850_params"
!madaer=3         ! 3: updated aerosols          ; 1: default sulfates/aerosols

! parameters that may have to be changed in emergencies:
DTsrc=1800.      ! cannot be changed after a run has been started
DT=450.
! parameters that control the Shapiro filter
DT_XUfilter=450. ! Shapiro filter on U in E-W direction; usually same as DT
DT_XVfilter=450. ! Shapiro filter on V in E-W direction; usually same as DT
DT_YVfilter=0.   ! Shapiro filter on V in N-S direction
DT_YUfilter=0.   ! Shapiro filter on U in N-S direction

#include "EOT_defaults"

NIsurf=1         ! (surf.interaction NIsurf times per physics time step)
!NRAD=5           ! radiation (every NRAD'th physics time step)
! parameters that affect at most diagn. output:
#include "planet_diag_params"

Nssw=2           ! until diurnal diags are fixed, Nssw has to be even
Ndisk=480
&&END_PARAMETERS

 &INPUTZ
 YEARI=1949,MONTHI=12,DATEI=1,HOURI=0, ! pick IYEAR1=YEARI (default) or < YEARI
 YEARE=1949,MONTHE=12,DATEE=2,HOURE=0,     KDIAG=12*0,9,
 ISTART=2,IRANDI=0, YEARE=1949,MONTHE=12,DATEE=1,HOURE=1,
!! suggested settings for P4qsF40:
!! YEARI=1901,MONTHI=1,DATEI=1,HOURI=0,
!! YEARE=1931,MONTHE=1,DATEE=1,HOURE=0,     KDIAG=12*0,9,
!! ISTART=8,IRANDI=0, YEARE=1901,MONTHE=1,DATEE=1,HOURE=1,
/
