P1SCM.R GISS Model E      M. Kelley 10/2013
                          A. Wolf 2/2017

SCM template planetary GCM  based on P4M40.R GISS radiation
    free-running using GCM inputs to initialize, then run with no dynamics,
    GCM surface forcings and no outside forcings 
    land point


Initial framework for truly single-column mode for Model E.

P4M40: modelE as frozen in July 2009 without gravity wave drag
modelE 4x5 hor. grid with 40 lyrs, top at .1 mb (+ 3 rad.lyrs)
atmospheric composition from year 1850
ocean data: prescribed, 1876-1885 climatology  (see OSST/SICE)
uses turbulence scheme, simple strat.drag (not grav.wave drag)
time steps: dynamics 7.5 min leap frog; physics 30 min.; radiation 2.5 hrs
filters: U,V in E-W and N-S direction (after every physics time step)
         U,V in E-W direction near poles (after every dynamics time step)
         sea level pressure (after every physics time step)
radiation: GISS

This is a functioning rundeck, not a template (excepting the lines
containing /path/to/user/directory/extractions - see notes below)

SCM-irrelevant codes and input files are excluded.
Template #includes should be refactored so that this exclusion happens automatically.

SCM case: P40M40 
For other cases, change one or more of the following as necessary:
(1) SCMDATA_XXXXXX case-specific code (until this aspect is generalized)
 (1*) also check SCM_COM.f for setup of flags for run with  SCM_SURFACE_FLAG=0 for Free-Running
(2) no SCM-specific forcing files
(3) lon_targ, lat_targ, and files extracted from gridded data at lon_targ, lat_targ
    See notes in the input files section on a pre-scripted extraction procedure etc.
    nominal_area may also be changed.

Preprocessor Options
#define SCM
#define USE_ENT
#define NEW_IO
#define PLANET_PARAMS notEarth
End Preprocessor Options

Object modules: (in order of decreasing priority)

AtmL40p 
AtmRes

SCM_COM
SCM_DIAG
SCMDATA_FR 
ATMDYN_SCM
ATMDYN_SCM_EXT
SCM_DIAG_COM

CLOUDS_COM CLOUDS2 CLOUDS2_DRV

SURFACE
PBL_COM PBL_DRV PBL 
ATURB_E1

LANDICE LANDICE_COM SURFACE_LANDICE LANDICE_DRV

GHY_COM GHY_DRV

VEG_DRV
! VEG_COM VEGETATION 
ENT_DRV ENT_COM ! + Ent

LAKES_COM LAKES

OCN_DRV OCEAN OCNML

SEAICE SEAICE_DRV ICEDYN_DUM
Zenith

RAD_COM RADIATION RAD_DRV
COSZ_2D RAD_UTILS ALBEDO READ_AERO ocalbedo

DIAG_COM DIAG DEFACC QUICKPRT

ATM_DRV ATMDYN_COM ATM_UTILS ATM_COM

MODEL_COM
IO_DRV
MODELE
MODELE_DRV

QUS_COM QUSDEF

FLUXES

STRAT_DUM

Components:
shared MPI_Support solvers giss_LSM 
dd2d
Ent

Component Options:
OPTS_Ent = ONLINE=YES PS_MODEL=FBB
OPTS_giss_LSM = USE_ENT=YES

Data input files:

! Forcing for SGP case
!SCMSRF=SGP.surface.0501.dat
!SCMLAY=SGP.layer.0501.dat

! The set of forcings for a particular SCM test case typically does not include
! all of the data required to run Model E.  Each line below of the form
!   SHORTNAME=/path/to/user/directory/extractions/filename.nc
! corresponds to a location-dependent input dataset for which one of the following
! two options must be chosen.  The second option is provided for convenience.
! (1) Replace /path/to/user/directory/extractions/filename.nc with the
!     path to a single-column file that has already been created somehow.
!     Note that the GCM file-reading infrastructure considers single-column
!     files to be on a horizontal grid of size 1, and therefore the
!     two horizontal dimensions must be retained in netcdf variables
!     (which must have the netcdf names that model E expects).
!     For any files previously extracted from global data via option (2),
!     make sure that the path does not contain substring "/extractions/"
!     if option (2) will be used create other files.
! (2) Use exec/extract_scm.sh to sample gridded files at location
!     lon_targ, lat_targ.
!     Firstly,
!       replace /path/to/user/directory with a real path, preferably which
!        (a) contains a string denoting the SCM location/case being run
!        (b) is unlikely to be chosen by any other users on the system
!       Habits (a) and (b) will prevent clutter and accidental overwrites.
!       Note that
!        (a) substring "/extractions/" must be retained in each path
!        (b) the rundeck paths indicate the resulting single-column files
!            to be read by the model.  GCMSEARCHPATH (from your modelErc)
!            is the location of the gridded file from which to extract the column
!        (c) There is no requirement that all files from which data are extracted are
!            on the same grid - dimension and coordinate information is scanned per-file.
!        (d) As currently programmed (10/2013), extract_scm.sh does require that
!            each file possesses 1D coordinate variables named lon(lon) and lat(lat).
!            Extraction from arbitrary grids (cubed-sphere etc.) will soon be enabled.
!        (e) NCO must be installed on your system and in your $PATH.
!     Secondly, execute
!        extract_scm.sh THISRUNDECK.R


! Topography, area fractions of surface types
TOPO=/path/to/user/directory/extractions/Z72X46N.cor4_nocasp.nc

! Atm. initial conditions (temperature, wind, humidity, surface pressure)
! on the model's vertical grid and consistent with the
! orography from TOPO.  While some SCM modes
! of operation may subsequently overwrite the values from
! this file, the model has not yet been programmed to
! skip reading this file if it is absent.
AIC=/path/to/user/directory/extractions/NCARIC.72x46.D7712010_ext.nc

! Aerosols and O3 are deactivated by default in planet rundecks ***
!DUSTaer=/path/to/user/directory/extractions/dust_mass_CakmurMillerJGR06_144x90x20x7x12.nc
!BC_dep=/path/to/user/directory/extractions/BC.Dry+Wet.depositions.ann.nc

! Optional: if absent and MADAER flag not set, aerosols are zero.
! If these files are omitted, rundeck parameters od_cdncx and cc_cdncx
! must not be set (or if set, set to zero.)
! Currently, these files must be used as a group (will change in future).
!TAero_SUL=/path/to/user/directory/extractions/SUL_Koch2008_kg_m2_72x46x20_1890-2000h.nc
!TAero_SSA=/path/to/user/directory/extractions/SSA_Koch2008_kg_m2_72x46x20h.nc
!TAero_NIT=/path/to/user/directory/extractions/NIT_Bauer2008_kg_m2_72x46x20_1890-2000h.nc
!TAero_OCA=/path/to/user/directory/extractions/OCA_Koch2008_kg_m2_72x46x20_1890-2000h.nc
!TAero_BCA=/path/to/user/directory/extractions/BCA_Koch2008_kg_m2_72x46x20_1890-2000h.nc
!TAero_BCB=/path/to/user/directory/extractions/BCB_Koch2008_kg_m2_72x46x20_1890-2000h.nc
! Optional: if absent, ozone is set to zero.
! Zero stratospheric ozone is usually a bad idea though.
!O3file=/path/to/user/directory/extractions/o3_2005_shindelltrop_72x46x49_1850-1997.nc

! These ocean files are only needed if the TOPO file for the
! SCM case contains a nonzero ocean fraction.  Certain SCM
! modes of operation may also prescribe ocean surface conditions
! via mechanisms other than these files. SICE and ZSIFAC can be
! omitted if the simulation location is free of sea ice.
OSST=/path/to/user/directory/extractions/OST4X5.B.1876-85avg.Hadl1.1.nc
OSST_eom=/path/to/user/directory/extractions/OST4X5.B.1876-85avg.Hadl1.1.nc

! rsi var. in SICE is sea ice fraction, ZSIFAC var. dm is used to get ice thickness
SICE=/path/to/user/directory/extractions/SICE4X5.B.1876-85avg.Hadl1.1.nc
SICE_eom=/path/to/user/directory/extractions/SICE4X5.B.1876-85avg.Hadl1.1.nc
ZSIFAC=/path/to/user/directory/extractions/SICE4X5.B.1876-85avg.Hadl1.1.nc
OCNML=/path/to/user/directory/extractions/Z1O.B4X5.cor.nc   

! These land-surface files are only needed if the TOPO file for
! the SCM case contains a nonzero land fraction.  But note
! that the GIC contains initial conditions for surface types other
! than the land surface and that the SOILIC method is an optional
! replacement for the land-surface GIC.
VEG=/path/to/user/directory/extractions/V72X46.1.cor2_no_crops.ext.nc
CROPS=/path/to/user/directory/extractions/CROPS2007_72X46N.cor4_nocasp.nc 
!soil_textures=/path/to/user/directory/extractions/soil_textures_top30cm
SOIL=/path/to/user/directory/extractions/S4X50093.ext.nc
SOILCARB_global=/path/to/user/directory/extractions/soilcarb_top30cm_4x5.nc
CDN=/path/to/user/directory/extractions/CD4X500S.ext.nc               ! surf.drag coefficient
TOP_INDEX=/path/to/user/directory/extractions/top_index_72x46_a.ij.ext.nc 


! Optional land-surface file which prescribes soil initial
! conditions in intuitive intensive units (temperature,
! relative wetness, snow depth) rather than the extensive
! units (total heat and water per layer) of the arrays in
! the file GIC.
!SOILIC=/path/to/SOILIC.nc

! Optional file to specify a "background" roughness
! length for the land surface that is not tied to
! the scale-dependent topographic standard deviation in
! TOP_INDEX as per the procedure developed for 8x10 Model II.
! Note that the actual roughness length for the
! land surface is taken as the maximum of the vegetation-derived
! value and the value from either ROUGHL or TOP_INDEX.
!ROUGHL=/path/to/ROUGHL.nc

! Initial conditions for surface components from an arbitrary restart file
!GIC=/path/to/user/directory/extractions/GIC.E046D3M20A.1DEC1955.ext_1.nc 
GIC=/path/to/user/directory/extractions/GIC.144X90.DEC01.1.ext_2.nc

! All input files below this line are location-independent.

GHG=GHG.Mar2009.txt
RADN1=sgpgxg.table8
RADN2=LWTables33k_lowH2O_CO2_O3_planck_1-800
RADN4=LWCorrTables33k
RADN5=H2Ocont_MT_CKD
RADN3=miescatpar.abcdv2
RH_QG_Mie=oct2003.relhum.nr.Q633G633.table
!RADN7=STRATAER.VOL.SATO.1850-1999.Apr02_hdr
!RADN8=cloud.epsilon4.72x46
RADN9=solar.DBbglean.ann850-2000.uvflux_hdr
RADNE=topcld.trscat8

! optional files for optional diagnostics
ISCCP=ISCCP.tautables
MSU_wts=MSU.RSS.weights.data

Label and Namelist:
P1SCM (P4M40 planet1 (4x5,Single Column Model)


&&PARAMETERS

! Southern Great Plains Target Coordinates (degrees E/N).
! lon_targ and lat_targ only affect the solar zenith angle and
! corolis parameter (the latter is used in PBL parameterizations).
lon_targ=-96.25
lat_targ=37. 
! nominal gridbox area (m2) from a 144x90 lon-lat grid at lat_targ
! nominal_area=49370385348.13
! nominal gridbox area (m2) from a 72x46 lon-lat grid 
nominal_area=194824641513.87  

!for removing diurnal cycle set COSZ to a constant for run
!COSZ=.28

!for removing seasonal cycle set orbital parameters
!planetName='notEarth'
!eccentricity=0.000
!obliquity=0.000
!quantizeYearLength='T'

#include "EOT_defaults"

DTsrc=1800.     ! Atm. physics timestep.
NIsurf=1        ! Number of surface physics timesteps per atm. physics timestep.
NRAD=1          ! Full radiation calculation every NRAD physics timesteps.

! cloud tuning parameters
U00a=.50
U00b=0.55
radiusl_multiplier=0.8
radiusi_multiplier=0.8

! Cloud inhomogeneity correction
KCLDEP=1    ! use a constant value for CLDEPS
EPSCON=0.12 ! use CLDEPS=0.12

! parameters that control temporally varying inputs:
! if set to 0, the current (day/) year is used: transient run
master_yr=1850
!crops_yr=1850  ! if -1, crops in VEG-file is used
!s0_yr=1850
!s0_day=182
!ghg_yr=1850
!ghg_day=182
volc_yr=-1
!volc_day=182
!aero_yr=1850
od_cdncx=0.        ! don't include 1st indirect effect
cc_cdncx=0.        ! don't include 2nd indirect effect (used 0.0036)
!albsn_yr=1850
!dalbsnX=.024
!o3_yr=-1850
! atmCO2=368.6          !uatm for year 2000 - enable for CO2 tracer runs

! radiation flags
KSIALB=0        ! 6-band albedo (Hansen) (=1 A.Lacis orig. 6-band alb)
KSOLAR=2
PTLISO=15.      ! press(mb) above which rad. assumes isothermal layers
!madaer=3        ! indicates use of TAero_XXX aerosol files by radiation.

CO2X=1.0
O3X=0. ! turn of O3, to turn on delete this line and add O3file
H2OstratX=1.0

H2ObyCH4=0.     ! deactivates strat.H2O generated by CH4
l_uniform_ghg=1 ! deactivates prescribed GHG distributions


xCDpbl=1.
cond_scheme=2    ! more elaborate conduction scheme (GHY, Nancy Kiang)


! parameters affecting diagn. output
aer_rad_forc=0   ! if set =1, radiation is called numerous times - slow !!
cloud_rad_forc=1 ! calls radiation twice; use =0 to save cpu time
isccp_diags=0    ! use =0 to save cpu time, but you lose some key diagnostics
nda5d=13         ! use =1 to get more accurate energy cons. diag (increases CPU time)
nda5s=13         ! use =1 to get more accurate energy cons. diag (increases CPU time)
ndaa=13
nda5k=13
nda4=48          ! to get daily energy history use nda4=24*3600/DTsrc

! KCOPY=1: save acc and alternating checkpoint files only.
! KCOPY=2: save end-of-month rsf also (probably not useful for SCM).
KCOPY=1

! save alternating checkpoint files every Ndisk timesteps
! (checkpoint also saved when model reaches end time).
! Useful for perusing instantaneous states or checking
! checking whether model states are identical after coding
! rearrangements.
Ndisk=1440

! restart state is saveable every nssw timesteps.
Nssw=2

! SCM-useful GCM-native subdaily diagnostics system not yet imported to master branch
!SUBDD=' '        ! no sub-daily frequency diags
!NSUBDD=0         ! saving sub-daily diags every NSUBDD-th physics time step (1/2 hr)

! KOCEAN=0 means prescribed surface ocean conditions.  This parameter is currently
! mandatory even if ocean is absent at the SCM location.
KOCEAN=0
!! KOCEAN=1        ! ocean is computed
Kvflxo=0        ! usually set to 1 only during a prescr.ocn run by editing "I"
!  Kvflxo=1     ! saves VFLXO files to prepare for q-flux runs (mkOTSPEC)
ocn_cycl=1      ! =0 if ocean varies from year to year

! variable lakes.  Probably unimportant for typical SCM simulation lengths.
! note that lakes can only evolve in response to local precip, evap, runoff.
variable_lk=1

wsn_max=2.   ! restrict snow depth to 2 m-h2o (if 0. snow depth is NOT restricted)


&&END_PARAMETERS

 &INPUTZ
 YEARI=1949,MONTHI=7,DATEI=1,HOURI=0, ! pick IYEAR1=YEARI (default) or < YEARI
 YEARE=1949,MONTHE=7,DATEE=2,HOURE=0,     KDIAG=12*0,9,
 ISTART=2,IRANDI=0, YEARE=1949,MONTHE=7,DATEE=31,HOURE=0,
/
