E4CubeTest.R GISS Model E coupled version         kelley 02/25/2010

E4CubeTest: C32 cubed-sphere version of E4M20 coupled to 4x5 13-layer ocean.
            Intended to be used for regression testing and demonstration only.

E4M20.R GISS Model E  2004 modelE                     rar     07/15/2009
E4M20: modelE as frozen in July 2009 without gravity wave drag
atmospheric composition from year 1850
time steps: physics 30 min.; radiation 2.5 hrs

Preprocessor Options
!#define TRACERS_ON                  ! include tracers code
#define CHECK_OCEAN                 ! needed to compile aux/file CMPE002
#define AG2OG_PRECIP_BUNDLE
#define OG2AG_TOC2SST_BUNDLE
#define AG2OG_OCEANS_BUNDLE
#define OG2AG_OCEANS_BUNDLE
#define BUNDLE_INTERP
#define NEW_IO
!#define CALC_GWDRAG                 ! need to make ZVAR for C32 res first
#define USE_ENT                  ! include dynamic vegetation model
#define SET_SOILCARBON_GLOBAL_TO_ZERO
!#define ROUGHL_HACK ! no longer needed?

End Preprocessor Options

Object modules: (in order of decreasing priority)

     ! resolution-specific source codes
AtmCS32                           ! 32 Cube-Sphere Grid
AtmL20 STRAT_DUM                 ! vertical resolution is 20 layers -> 0.1mb
RES_5x4_L13                         ! ocean horiz res 4x5deg, 13 layers
OFFT72E                             ! Fast Fourier Transform
DIAG_RES_M                          ! diagnostics (resolution dependent)

     ! Codes used by the cubed-atmosphere configuration (FV dynamics)
#include "cubed_sphere_source_files"
STRAT_DIAG                          ! dynamics diagnostics

#include "modelE4_source_files"
#include "dynamic_ocn_source_files"
regrid_com                          ! auxiliary regrid routines

Components:
#include "E4_components"    /* without "Ent" */
Ent
dd2d

Component Options:
OPTS_Ent = ONLINE=YES PS_MODEL=FBB
OPTS_giss_LSM = USE_ENT=YES
FVCUBED = YES

Data input files:
  ! atmosphere, land surface, and sea ice
AIC=AIC_CS32.nc                  ! initial conditions (atm.)      needs GIC, ISTART=2
GIC=GIC_CS32_1.nc                  ! I.C. for land surface and sea ice
TOPO=Z_CS32_4X5.nc               ! topography
SOIL=SOIL_CS32.nc                ! soil types
VEG=V_CS32_144X90_1percent.nc    ! veg. fractions
CROPS=CROPS_CS32_4X5.nc          ! crops history
CDN=CD_CS32.nc                   ! surf.drag coefficient
REG=REG.txt                      ! special regions-diag
RVR=RDdistocean_CS32.nc             ! river direction file
NAMERVR=RDdistocean_CS32.names.txt  ! named river outlets
TOP_INDEX=top_index_CS32.nc         ! only used if #define DO_TOPMODEL_RUNOFF

  ! ocean
OIC=OIC4X5LD.Z12.gas1.CLEV94.DEC01.nc ! ocean initial conditions
OFTAB=OFTABLE_NEW                    ! ocean function table
KBASIN=KB4X513.OCN.gas1.nc           ! ocean basin designations
TOPO_OC=OZ72X46N_gas.1_nocasp.nc     ! ocean bdy.cond
OSTRAITS=OSTRAITS_72x46.nml          ! parameterized straits info
GLMELT=GLMELT_CS32.nc                   ! glacial melt distribution (on atm grid)
REMAP=remap72-46C32-32.nc            ! weights for atm-ocean coupling

#include "rad_input_files"
#include "rad_C32_input_files"

MSU_wts=MSU.RSS.weights.data

Label and Namelist:
E4CubeTest (cubed-sphere version of E4M20 coupled to 4x5 13-layer ocean)

&&PARAMETERS
#include "dynamic_ocn_params"

wsn_max=2.   ! restrict snow depth to 2 m-h2o (if 0. snow depth is NOT restricted)

! drag params if grav.wave drag is not used and top is at .01mb
X_SDRAG=.002,.0002  ! used above P(P)_sdrag mb (and in top layer)
C_SDRAG=.0002       ! constant SDRAG above PTOP=150mb
P_sdrag=1.          ! linear SDRAG only above 1mb (except near poles)
PP_sdrag=1.         ! linear SDRAG above PP_sdrag mb near poles
P_CSDRAG=1.         ! increase CSDRAG above P_CSDRAG to approach lin. drag
Wc_JDRAG=30.        ! crit.wind speed for J-drag (Judith/Jim)
ANG_SDRAG=1         ! conserve ang. mom.

xCDpbl=1.
! cond_scheme=2    ! more elaborate conduction scheme (GHY, Nancy Kiang)

UOdrag=1 ! for flux-coupler verifications, atmosphere sees nonzero ocean/seaice velocity

U00a=.55    ! above 850mb w/o MC region; tune this first to get 30-35% high clouds
U00b=1.00   ! below 850mb and MC regions; then tune this to get rad.balance
! U00a,U00b replace the U00 parameters below - U00ice/U00wtrX are kept only for the _E1 version
U00ice=.59      ! U00ice up => nethtz0 down (alb down); goals: nethtz0=0,plan.alb=30%
U00wtrX=1.39    ! U00wtrX+.01=>nethtz0+.7                      for global annual mean
!?1979 U00wtrX=1.38
! HRMAX=500.    ! not needed unless do_blU00=1, HRMAX up => nethtz0 down (alb up)

CO2X=1.
H2OstratX=1.
KSIALB=0        ! 6-band albedo (Hansen) (=1 A.Lacis orig. 6-band alb)

PTLISO=15.       ! press(mb) above which rad. assumes isothermal layers
H2ObyCH4=1.      ! activates strat.H2O generated by CH4
KSOLAR=2         ! 2: use long annual mean file ; 1: use short monthly file

#include "atmCompos_1850_params"
madaer=3         ! 3: updated aerosols          ; 1: default sulfates/aerosols

DTsrc=1800.      ! physics timestep
DT=1800.         ! for FV dynamics, set same as DTsrc

! parameters that may have to be changed in emergencies:
NIsurf=1        ! increase as layer 1 gets thinner

#include "diag_params"

Nssw=2           ! until diurnal diags are fixed, Nssw has to be even
Ndisk=480       ! use =48 except on halem

&&END_PARAMETERS

 &INPUTZ
   YEARI=1901,MONTHI=1,DATEI=1,HOURI=0, !  from default: IYEAR1=YEARI
   YEARE=1901,MONTHE=1,DATEE=2,HOURE=0, KDIAG=13*0,
   ISTART=2,IRANDI=0, YEARE=1901,MONTHE=1,DATEE=1,HOURE=1
/
