module Zenith_mod
  use DOMAIN_DECOMP_1D, only: AM_I_ROOT
   implicit none
   private

   public :: calc_zenith_angle

contains

   subroutine calc_zenith_angle(clock, nStep, cosz, cosza)
!@sum calculate zenith angle for current time step
!@auth Gavin Schmidt (from RADIA)  (revised by T. Clune)
!@var nStep - number of timesteps over which to average
!@var cosz - array of zenith angles weighted by time
!@var cosza - weighted by incident light

      use CONSTANT, only : twopi, pi
      use ModelClock_mod
      use Rational_mod
      use BaseTime_mod, only: BaseTime, newBaseTime
      use Time_mod
      USE TimeInterval_mod

      use TimeConstants_mod, only: SECONDS_PER_DAY
      USE RAD_COM, only : useOrbit => orbit
      USE RAD_COSZ0, only : coszt, coszs

      IMPLICIT NONE

      type (ModelClock), intent(in) :: clock
      integer, intent(in) :: nStep
      real*8, intent(inout) :: cosz(:,:)
      real*8, optional, intent(inout) :: cosza(:,:)

      REAL*8 :: rot1, rot2
      type (Time) :: t1, t2
      real*8, parameter :: TINY = 1.d-10 ! radians


      ! Hour angle is 0 at noon.  cosz*() routines use
      ! angles from midnight.  Need to add pi
      t1 = clock%getCurrentTime()
      rot1 = modulo(useOrbit%getHourAngle(t1), twopi)

      t2 = t1
      call t2%add(nstep * clock%getDt())
      rot2 = modulo(useOrbit%getHourAngle(t2), twopi)

      ! coszt() and coszs() cannot handle retrograde conditions, so we
      ! need to either swap or add 2pi to rot1/rot2 depending on the
      ! values found.  We start with the values in [0, 2pi)
      if (modulo(rot2-rot1, twopi) > pi) then
         call swap(rot1, rot2)
      end if
      if (rot2 < rot1) then
         rot2 = rot2 + twopi
      else if (rot2 == rot1) then
         rot2 = rot2 + TINY
      end if

      ! coszt() also cannot correctly handle very small differences
      ! in hour angles, so must force at least TINY.
      if (abs(rot2 - rot1) < tiny) then
         rot2 = rot1 + TINY
      end if

      if (.not. present(cosza)) then
         call coszt (rot1, rot2, cosz)
      else
         call coszs (rot1, rot2, cosz, cosza)
      end if

! Uncomment below to debug zenith angle things
!$$      if (am_i_root()) then
!$$         print*,'Rot: ', real(rot1)*180/pi, real(rot2)*180/pi
!$$      end if

   contains

      subroutine swap(a, b)
         real*8, intent(inout) :: a
         real*8, intent(inout) :: b
         real*8 :: tmp

         tmp = a
         a = b
         b = tmp
      end subroutine swap

   end subroutine calc_zenith_angle

end module Zenith_mod

