! This file uses "f90_interface" m4 macros - plese follow corresponding rules.
! You can always look at ent_mod.f to see how these macros were
! expanded (but don't edit that file)


!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!                                                              !
!                   DO NOT EDIT THIS FILE !!!                  !
!                                                              !
! This file is generated automatically by m4 preprocessor.     !
! If you need to modyfy it plese edit corresponding *.m4f file.!
!                                                              !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!





      module ent_mod
!@sum this module contains the interface to Ent dynamic vegetation model
!@+   this is the only module that should be visible to GCM
 
      ! need to know about internal structure of Ent types
      use ent_types, only : entcelltype, patch, cohort, timestruct,
     &     MAX_PATCHES, MAX_COHORTS, ent_config
      use ent_const, only : N_BANDS,N_COVERTYPES
     &     , N_OTHER, COVER_SAND
     &     , N_DEPTH,N_SOIL_TEXTURES
     &     , N_BPOOLS, N_PFT, N_CASA_LAYERS,NPOOLS,NLIVE,CARBON,PTRACE
      !use ent_prescrveg
      use entcells
      use ent_pfts, only : CROPS,COVEROFFSET

      !use prescr_veg ! just for compilation purposes
      implicit none

      private

      !--- public constants ---
      public N_BANDS, N_COVERTYPES 
      public N_OTHER, COVER_SAND
      public N_DEPTH, N_SOIL_TEXTURES, N_BPOOLS
      public N_PFT, N_CASA_LAYERS  !added last one -PK
      public PTRACE, NPOOLS, NLIVE, CARBON  
      public ent_config
      public CROPS,COVEROFFSET

      public entcelltype_public, ent_cell_pack, ent_cell_unpack
      public ent_get_exports, ent_set_forcings
      public ent_cell_construct, ent_cell_destruct, ent_cell_nullify
      public ent_fast_processes,ent_run,ent_vegcover_update
      public ent_cell_set !, ent_cell_update
      public ent_prescribe_vegupdate
      public ent_prescribe_vegupdateB
      public ent_prescribe_vegupdateC
      public ent_prescribe_vegupdateD
      public ent_cell_print
      public ent_initialize

      public ent_set_forcings_r8_0

      type entcelltype_public
        private
        type(entcelltype), pointer :: entcell => null()
      end type entcelltype_public

      !---- public interfaces ---

      !--- consttructor/destructor ---
      interface ent_cell_construct
       
        module procedure ent_cell_construct_r8_0
       
        module procedure ent_cell_construct_r8_1
       
        module procedure ent_cell_construct_r8_2
      
      end interface

      interface ent_cell_destruct
      
        module procedure ent_cell_destruct_r8_0
      
        module procedure ent_cell_destruct_r8_1
      
        module procedure ent_cell_destruct_r8_2
      
      end interface

      interface ent_cell_nullify
      
        module procedure ent_cell_nullify_r8_0
      
        module procedure ent_cell_nullify_r8_1
      
        module procedure ent_cell_nullify_r8_2
      
      end interface

      interface ent_cell_pack
      module procedure ent_cell_pack
      module procedure ent_cell_pack_2d
      end interface

      !--- passing initial data to ent cells ---
      interface ent_cell_set
      
        module procedure ent_cell_set_r8_0
      
        module procedure ent_cell_set_r8_1
      
        module procedure ent_cell_set_r8_2
      
      end interface


      !--- passing updated prescribed data to ent cells ---
cddd      interface ent_cell_update
cddd        module procedure ent_cell_update_single
cddd      end interface ent_cell_update

      !--- set forcings / get exports ---
      interface ent_set_forcings
      
        module procedure ent_set_forcings_r8_0
      
        module procedure ent_set_forcings_r8_1
      
        module procedure ent_set_forcings_r8_2
      
      end interface

      interface ent_get_exports
      
        module procedure ent_get_exports_r8_0
      
        module procedure ent_get_exports_r8_1
      
        module procedure ent_get_exports_r8_2
      
      end interface

      !--- run model for fast/medium/slow physics ---
      interface ent_fast_processes
      
        module procedure ent_fast_processes_r8_0
      
        module procedure ent_fast_processes_r8_1
      
        module procedure ent_fast_processes_r8_2
      
      end interface

      interface ent_run
      
        module procedure ent_run_r8_0
      
        module procedure ent_run_r8_1
      
        module procedure ent_run_r8_2
      
      end interface

      interface ent_vegcover_update
      
        module procedure ent_vegcover_update_r8_0
      
        module procedure ent_vegcover_update_r8_1
      
        module procedure ent_vegcover_update_r8_2
      
      end interface

      interface ent_cell_print
      
        module procedure ent_cell_print_r8_0
      
        module procedure ent_cell_print_r8_1
      
        module procedure ent_cell_print_r8_2
      
      end interface


!!! do we need 1d and 2d array interfaces for pack/unpack ?

      !---- private interfaces ----
      interface copy_vars
        module procedure copy_vars_single
        module procedure copy_vars_array
        module procedure copy_vars_i_single
        module procedure copy_vars_i_array
      end interface

      interface ent_prescribe_vegupdate
      
        module procedure ent_prescribe_vegupdate_r8_0
      
        module procedure ent_prescribe_vegupdate_r8_1
      
        module procedure ent_prescribe_vegupdate_r8_2
      
      end interface

      interface ent_prescribe_vegupdateB
      
        module procedure ent_prescribe_vegupdateB_r8_0
      
        module procedure ent_prescribe_vegupdateB_r8_1
      
        module procedure ent_prescribe_vegupdateB_r8_2
      
      end interface

      interface ent_prescribe_vegupdateC
      
        module procedure ent_prescribe_vegupdateC_r8_0
      
        module procedure ent_prescribe_vegupdateC_r8_1
      
        module procedure ent_prescribe_vegupdateC_r8_2
      
      end interface

      interface ent_prescribe_vegupdateD
      
        module procedure ent_prescribe_vegupdateD_r8_0
      
        module procedure ent_prescribe_vegupdateD_r8_1
      
        module procedure ent_prescribe_vegupdateD_r8_2
      
      end interface


      !---- global data ----
      type(ent_config), save :: config

      contains

!*************************************************************************
      subroutine ent_initialize(
     &     do_soilresp, do_phenology_activegrowth, do_structuralgrowth, 
     &     do_frost_hardiness, do_patchdynamics)
!@sum initializes Ent module. This subroutine should set all the flags
!@+   and all the variables that are constant during the run.
      logical, optional :: do_soilresp
      logical, optional :: do_phenology_activegrowth
      logical, optional :: do_structuralgrowth
      logical, optional :: do_frost_hardiness
      logical, optional :: do_patchdynamics

      ! first set some defaults:
      config%do_soilresp = .false.
      config%do_phenology_activegrowth = .false.
      config%do_structuralgrowth = .false.
      config%do_frost_hardiness = .true.
      config%do_patchdynamics = .false.

      ! now overwrite defaults with explicitly passed values
      if ( present(do_soilresp) ) config%do_soilresp = do_soilresp
      if ( present(do_phenology_activegrowth) ) 
     &     config%do_phenology_activegrowth = do_phenology_activegrowth
      if ( present(do_structuralgrowth) ) config%do_structuralgrowth = 
     &     do_structuralgrowth
      if ( present(do_frost_hardiness) ) config%do_frost_hardiness = 
     &     do_frost_hardiness
      if ( present(do_patchdynamics) ) config%do_patchdynamics = 
     &     do_patchdynamics

      end subroutine ent_initialize

!*************************************************************************
!---- interfaces to run the model one time step --------------------------


      subroutine ent_prescribe_vegupdate_r8_0(entcell
     &     ,hemi,jday,year,
     &     update_crops, do_giss_phenology, do_giss_lai, do_giss_albedo,
     &     laidata, hdata, albedodata, cropsdata, init)
!@sum updates prescribed vegatation parameters. This parameters can
!@+   be passed directly in form of arrays like laidata or one can
!@+   set a flag requesting certain action like do_giss_phenology.
!@+   All arguments except entcell are optional.
      use ent_prescribed_updates, only:  entcell_vegupdate
      type(entcelltype_public),intent(inout) :: entcell 
      integer, intent(in), optional, target :: hemi 
      integer,intent(in), optional :: jday,year
      logical, intent(in), optional :: update_crops
      logical, intent(in), optional :: do_giss_phenology
      logical, intent(in), optional :: do_giss_lai
      logical, intent(in), optional :: do_giss_albedo
      real*8, intent(in), optional, target ::
     &     laidata(:)
      real*8, intent(in), optional, target :: hdata(:)
      real*8, intent(in), optional, target ::
     &     albedodata(:,:)
      real*8, intent(in), optional, target :: cropsdata 
      logical, intent(in), optional :: init !If initialization call.
      !---
      !!!real*8, allocatable :: cropsdata_loc(:,:)
      real*8, pointer :: laidata_1(:), hdata_1(:),
     &     albedodata_1(:,:), cropsdata_1
      integer :: hemi_1, jday_1
      logical :: do_giss_phenology_1, do_giss_lai_1, do_giss_albedo_1
      logical :: init_1
      
      

      
      

      if ( present(update_crops) ) then
        if ( update_crops ) then
          if ( .not. present(year) )
     &         call stop_model("ent_prescribe_vegupdate: need year",255)
          !!!allocate ( cropsdata_loc(ic,jc) )
          ! insert call to get_crops here
          ! maybe we can avoid it ? I mean could we always
          ! pass cropdata from the driver?
        endif
      endif

      ! set defaults
      nullify( laidata_1, hdata_1, albedodata_1, cropsdata_1 )
      do_giss_phenology_1 = .false.
      do_giss_lai_1 = .true.
      do_giss_albedo_1 = .false.
      hemi_1 = -32768
      jday_1 = -32768
      init_1 = .false.

      ! now set optional arguments
      if ( present(do_giss_phenology) )
     &     do_giss_phenology_1 = do_giss_phenology
      if ( present(do_giss_lai) )
     &     do_giss_lai_1 = do_giss_lai
      if ( present(do_giss_albedo) )
     &     do_giss_albedo_1 = do_giss_albedo
      if ( present(jday) ) jday_1 = jday
      if ( present(init) ) init_1 = init
         
      
          ! skip uninitialized cells (no land)
        if ( associated(entcell%entcell) ) then

          if ( present(laidata) ) laidata_1 =>
     &         laidata(:)
          if ( present(hdata) ) hdata_1 => hdata(:)
          if ( present(albedodata) ) albedodata_1 =>
     &         albedodata(:,:)
          if ( present(cropsdata) ) cropsdata_1 =>
     &         cropsdata
          if ( present(hemi) ) hemi_1 = hemi

!          write(780,*) __FILE__,__LINE__,hemi_1
          
          call entcell_vegupdate(entcell%entcell,
     &         hemi_1,
     &         jday_1, do_giss_phenology_1, do_giss_lai_1,
     &         do_giss_albedo_1,
     &         laidata_1, hdata_1, albedodata_1, cropsdata_1,
     &         init_1)
        endif
      

      end subroutine ent_prescribe_vegupdate_r8_0

      subroutine ent_prescribe_vegupdate_r8_1(entcell
     &     ,hemi,jday,year,
     &     update_crops, do_giss_phenology, do_giss_lai, do_giss_albedo,
     &     laidata, hdata, albedodata, cropsdata, init)
!@sum updates prescribed vegatation parameters. This parameters can
!@+   be passed directly in form of arrays like laidata or one can
!@+   set a flag requesting certain action like do_giss_phenology.
!@+   All arguments except entcell are optional.
      use ent_prescribed_updates, only:  entcell_vegupdate
      type(entcelltype_public),intent(inout) :: entcell (:)
      integer, intent(in), optional, target :: hemi (:)
      integer,intent(in), optional :: jday,year
      logical, intent(in), optional :: update_crops
      logical, intent(in), optional :: do_giss_phenology
      logical, intent(in), optional :: do_giss_lai
      logical, intent(in), optional :: do_giss_albedo
      real*8, intent(in), optional, target ::
     &     laidata(:,:)
      real*8, intent(in), optional, target :: hdata(:,:)
      real*8, intent(in), optional, target ::
     &     albedodata(:,:,:)
      real*8, intent(in), optional, target :: cropsdata (:)
      logical, intent(in), optional :: init !If initialization call.
      !---
      !!!real*8, allocatable :: cropsdata_loc(:,:)
      real*8, pointer :: laidata_1(:), hdata_1(:),
     &     albedodata_1(:,:), cropsdata_1
      integer :: hemi_1, jday_1
      logical :: do_giss_phenology_1, do_giss_lai_1, do_giss_albedo_1
      logical :: init_1
      integer i1
      integer dims(2,1)

      dims(1,:) = lbound(entcell)
      dims(2,:) = ubound(entcell)

      if ( present(update_crops) ) then
        if ( update_crops ) then
          if ( .not. present(year) )
     &         call stop_model("ent_prescribe_vegupdate: need year",255)
          !!!allocate ( cropsdata_loc(ic,jc) )
          ! insert call to get_crops here
          ! maybe we can avoid it ? I mean could we always
          ! pass cropdata from the driver?
        endif
      endif

      ! set defaults
      nullify( laidata_1, hdata_1, albedodata_1, cropsdata_1 )
      do_giss_phenology_1 = .false.
      do_giss_lai_1 = .true.
      do_giss_albedo_1 = .false.
      hemi_1 = -32768
      jday_1 = -32768
      init_1 = .false.

      ! now set optional arguments
      if ( present(do_giss_phenology) )
     &     do_giss_phenology_1 = do_giss_phenology
      if ( present(do_giss_lai) )
     &     do_giss_lai_1 = do_giss_lai
      if ( present(do_giss_albedo) )
     &     do_giss_albedo_1 = do_giss_albedo
      if ( present(jday) ) jday_1 = jday
      if ( present(init) ) init_1 = init
         
      
      do i1=dims(1,1),dims(2,1)
          ! skip uninitialized cells (no land)
        if ( associated(entcell(i1)%entcell) ) then

          if ( present(laidata) ) laidata_1 =>
     &         laidata(:,i1)
          if ( present(hdata) ) hdata_1 => hdata(:,i1)
          if ( present(albedodata) ) albedodata_1 =>
     &         albedodata(:,:,i1)
          if ( present(cropsdata) ) cropsdata_1 =>
     &         cropsdata(i1)
          if ( present(hemi) ) hemi_1 = hemi(i1)

!          write(780,*) __FILE__,__LINE__,hemi_1
          
          call entcell_vegupdate(entcell(i1)%entcell,
     &         hemi_1,
     &         jday_1, do_giss_phenology_1, do_giss_lai_1,
     &         do_giss_albedo_1,
     &         laidata_1, hdata_1, albedodata_1, cropsdata_1,
     &         init_1)
        endif
      
      enddo

      end subroutine ent_prescribe_vegupdate_r8_1

      subroutine ent_prescribe_vegupdate_r8_2(entcell
     &     ,hemi,jday,year,
     &     update_crops, do_giss_phenology, do_giss_lai, do_giss_albedo,
     &     laidata, hdata, albedodata, cropsdata, init)
!@sum updates prescribed vegatation parameters. This parameters can
!@+   be passed directly in form of arrays like laidata or one can
!@+   set a flag requesting certain action like do_giss_phenology.
!@+   All arguments except entcell are optional.
      use ent_prescribed_updates, only:  entcell_vegupdate
      type(entcelltype_public),intent(inout) :: entcell (:,:)
      integer, intent(in), optional, target :: hemi (:,:)
      integer,intent(in), optional :: jday,year
      logical, intent(in), optional :: update_crops
      logical, intent(in), optional :: do_giss_phenology
      logical, intent(in), optional :: do_giss_lai
      logical, intent(in), optional :: do_giss_albedo
      real*8, intent(in), optional, target ::
     &     laidata(:,:,:)
      real*8, intent(in), optional, target :: hdata(:,:,:)
      real*8, intent(in), optional, target ::
     &     albedodata(:,:,:,:)
      real*8, intent(in), optional, target :: cropsdata (:,:)
      logical, intent(in), optional :: init !If initialization call.
      !---
      !!!real*8, allocatable :: cropsdata_loc(:,:)
      real*8, pointer :: laidata_1(:), hdata_1(:),
     &     albedodata_1(:,:), cropsdata_1
      integer :: hemi_1, jday_1
      logical :: do_giss_phenology_1, do_giss_lai_1, do_giss_albedo_1
      logical :: init_1
      integer i1,i2
      integer dims(2,2)

      dims(1,:) = lbound(entcell)
      dims(2,:) = ubound(entcell)

      if ( present(update_crops) ) then
        if ( update_crops ) then
          if ( .not. present(year) )
     &         call stop_model("ent_prescribe_vegupdate: need year",255)
          !!!allocate ( cropsdata_loc(ic,jc) )
          ! insert call to get_crops here
          ! maybe we can avoid it ? I mean could we always
          ! pass cropdata from the driver?
        endif
      endif

      ! set defaults
      nullify( laidata_1, hdata_1, albedodata_1, cropsdata_1 )
      do_giss_phenology_1 = .false.
      do_giss_lai_1 = .true.
      do_giss_albedo_1 = .false.
      hemi_1 = -32768
      jday_1 = -32768
      init_1 = .false.

      ! now set optional arguments
      if ( present(do_giss_phenology) )
     &     do_giss_phenology_1 = do_giss_phenology
      if ( present(do_giss_lai) )
     &     do_giss_lai_1 = do_giss_lai
      if ( present(do_giss_albedo) )
     &     do_giss_albedo_1 = do_giss_albedo
      if ( present(jday) ) jday_1 = jday
      if ( present(init) ) init_1 = init
         
      
      do i1=dims(1,1),dims(2,1)
      do i2=dims(1,2),dims(2,2)
          ! skip uninitialized cells (no land)
        if ( associated(entcell(i1,i2)%entcell) ) then

          if ( present(laidata) ) laidata_1 =>
     &         laidata(:,i1,i2)
          if ( present(hdata) ) hdata_1 => hdata(:,i1,i2)
          if ( present(albedodata) ) albedodata_1 =>
     &         albedodata(:,:,i1,i2)
          if ( present(cropsdata) ) cropsdata_1 =>
     &         cropsdata(i1,i2)
          if ( present(hemi) ) hemi_1 = hemi(i1,i2)

!          write(780,*) __FILE__,__LINE__,hemi_1
          
          call entcell_vegupdate(entcell(i1,i2)%entcell,
     &         hemi_1,
     &         jday_1, do_giss_phenology_1, do_giss_lai_1,
     &         do_giss_albedo_1,
     &         laidata_1, hdata_1, albedodata_1, cropsdata_1,
     &         init_1)
        endif
      
      enddo
      enddo

      end subroutine ent_prescribe_vegupdate_r8_2

     

      subroutine ent_prescribe_vegupdateB_r8_0(entcell)
!@sum updates prescribed vegatation parameters. This parameters can
!@+   be passed directly in form of arrays like laidata or one can
!@+   set a flag requesting certain action like do_giss_phenology.
!@+   All arguments except entcell are optional.
      use ent_prescribed_updates, only:  entcell_vegupdate
      type(entcelltype_public),intent(inout) :: entcell 
      !---
      !!!real*8, allocatable :: cropsdata_loc(:,:)
      real*8, pointer :: laidata_1(:), hdata_1(:),
     &     albedodata_1(:,:), cropsdata_1
      integer :: hemi_1, jday_1
      logical :: do_giss_phenology_1, do_giss_lai_1, do_giss_albedo_1
      logical :: init_1
      
      

      
      


      ! set defaults
      nullify( laidata_1, hdata_1, albedodata_1, cropsdata_1 )
      do_giss_phenology_1 = .false.
      do_giss_lai_1 = .true.
      do_giss_albedo_1 = .false.
      hemi_1 = -32768
      jday_1 = -32768
      init_1 = .false.

      ! now set optional arguments
         
      
          ! skip uninitialized cells (no land)
        if ( associated(entcell%entcell) ) then

!          write(780,*) __FILE__,__LINE__,hemi_1
          
          call entcell_vegupdate(entcell%entcell,
     &         hemi_1,
     &         jday_1, do_giss_phenology_1, do_giss_lai_1,
     &         do_giss_albedo_1,
     &         laidata_1, hdata_1, albedodata_1, cropsdata_1,
     &         init_1)
        endif
      

      end subroutine ent_prescribe_vegupdateB_r8_0

      subroutine ent_prescribe_vegupdateB_r8_1(entcell)
!@sum updates prescribed vegatation parameters. This parameters can
!@+   be passed directly in form of arrays like laidata or one can
!@+   set a flag requesting certain action like do_giss_phenology.
!@+   All arguments except entcell are optional.
      use ent_prescribed_updates, only:  entcell_vegupdate
      type(entcelltype_public),intent(inout) :: entcell (:)
      !---
      !!!real*8, allocatable :: cropsdata_loc(:,:)
      real*8, pointer :: laidata_1(:), hdata_1(:),
     &     albedodata_1(:,:), cropsdata_1
      integer :: hemi_1, jday_1
      logical :: do_giss_phenology_1, do_giss_lai_1, do_giss_albedo_1
      logical :: init_1
      integer i1
      integer dims(2,1)

      dims(1,:) = lbound(entcell)
      dims(2,:) = ubound(entcell)


      ! set defaults
      nullify( laidata_1, hdata_1, albedodata_1, cropsdata_1 )
      do_giss_phenology_1 = .false.
      do_giss_lai_1 = .true.
      do_giss_albedo_1 = .false.
      hemi_1 = -32768
      jday_1 = -32768
      init_1 = .false.

      ! now set optional arguments
         
      
      do i1=dims(1,1),dims(2,1)
          ! skip uninitialized cells (no land)
        if ( associated(entcell(i1)%entcell) ) then

!          write(780,*) __FILE__,__LINE__,hemi_1
          
          call entcell_vegupdate(entcell(i1)%entcell,
     &         hemi_1,
     &         jday_1, do_giss_phenology_1, do_giss_lai_1,
     &         do_giss_albedo_1,
     &         laidata_1, hdata_1, albedodata_1, cropsdata_1,
     &         init_1)
        endif
      
      enddo

      end subroutine ent_prescribe_vegupdateB_r8_1

      subroutine ent_prescribe_vegupdateB_r8_2(entcell)
!@sum updates prescribed vegatation parameters. This parameters can
!@+   be passed directly in form of arrays like laidata or one can
!@+   set a flag requesting certain action like do_giss_phenology.
!@+   All arguments except entcell are optional.
      use ent_prescribed_updates, only:  entcell_vegupdate
      type(entcelltype_public),intent(inout) :: entcell (:,:)
      !---
      !!!real*8, allocatable :: cropsdata_loc(:,:)
      real*8, pointer :: laidata_1(:), hdata_1(:),
     &     albedodata_1(:,:), cropsdata_1
      integer :: hemi_1, jday_1
      logical :: do_giss_phenology_1, do_giss_lai_1, do_giss_albedo_1
      logical :: init_1
      integer i1,i2
      integer dims(2,2)

      dims(1,:) = lbound(entcell)
      dims(2,:) = ubound(entcell)


      ! set defaults
      nullify( laidata_1, hdata_1, albedodata_1, cropsdata_1 )
      do_giss_phenology_1 = .false.
      do_giss_lai_1 = .true.
      do_giss_albedo_1 = .false.
      hemi_1 = -32768
      jday_1 = -32768
      init_1 = .false.

      ! now set optional arguments
         
      
      do i1=dims(1,1),dims(2,1)
      do i2=dims(1,2),dims(2,2)
          ! skip uninitialized cells (no land)
        if ( associated(entcell(i1,i2)%entcell) ) then

!          write(780,*) __FILE__,__LINE__,hemi_1
          
          call entcell_vegupdate(entcell(i1,i2)%entcell,
     &         hemi_1,
     &         jday_1, do_giss_phenology_1, do_giss_lai_1,
     &         do_giss_albedo_1,
     &         laidata_1, hdata_1, albedodata_1, cropsdata_1,
     &         init_1)
        endif
      
      enddo
      enddo

      end subroutine ent_prescribe_vegupdateB_r8_2

     

      subroutine ent_prescribe_vegupdateC_r8_0(entcell
     &     ,hemi,jday,year,
     &     do_giss_phenology, do_giss_albedo, do_giss_lai, 
     &     update_crops)
!@sum updates prescribed vegatation parameters. This parameters can
!@+   be passed directly in form of arrays like laidata or one can
!@+   set a flag requesting certain action like do_giss_phenology.
!@+   All arguments except entcell are optional.
      use ent_prescribed_updates, only:  entcell_vegupdate
      type(entcelltype_public),intent(inout) :: entcell 
      integer, intent(in), target :: hemi 
      integer,intent(in) :: jday,year
      logical, intent(in) :: update_crops
      logical, intent(in) :: do_giss_phenology
      logical, intent(in) :: do_giss_lai
      logical, intent(in) :: do_giss_albedo
      !---
      !!!real*8, allocatable :: cropsdata_loc(:,:)
      real*8, pointer :: laidata_1(:), hdata_1(:),
     &     albedodata_1(:,:), cropsdata_1
      integer :: hemi_1, jday_1
      logical :: do_giss_phenology_1, do_giss_lai_1, do_giss_albedo_1
      logical :: init_1
      
      

      
      

      ! set defaults
      nullify( laidata_1, hdata_1, albedodata_1, cropsdata_1 )
      do_giss_phenology_1 = .false.
      do_giss_lai_1 = .true.
      do_giss_albedo_1 = .false.
      hemi_1 = -32768
      jday_1 = -32768
      init_1 = .false.

      ! now set optional arguments
          do_giss_phenology_1 = do_giss_phenology
          do_giss_lai_1 = do_giss_lai
          do_giss_albedo_1 = do_giss_albedo
          jday_1 = jday
         
      
          ! skip uninitialized cells (no land)
        if ( associated(entcell%entcell) ) then

           hemi_1 = hemi
!          write(780,*) __FILE__,__LINE__,hemi_1
          
          call entcell_vegupdate(entcell%entcell,
     &         hemi_1,
     &         jday_1, do_giss_phenology_1, do_giss_lai_1,
     &         do_giss_albedo_1,
     &         laidata_1, hdata_1, albedodata_1, cropsdata_1,
     &         init_1)
        endif
      

      end subroutine ent_prescribe_vegupdateC_r8_0

      subroutine ent_prescribe_vegupdateC_r8_1(entcell
     &     ,hemi,jday,year,
     &     do_giss_phenology, do_giss_albedo, do_giss_lai, 
     &     update_crops)
!@sum updates prescribed vegatation parameters. This parameters can
!@+   be passed directly in form of arrays like laidata or one can
!@+   set a flag requesting certain action like do_giss_phenology.
!@+   All arguments except entcell are optional.
      use ent_prescribed_updates, only:  entcell_vegupdate
      type(entcelltype_public),intent(inout) :: entcell (:)
      integer, intent(in), target :: hemi (:)
      integer,intent(in) :: jday,year
      logical, intent(in) :: update_crops
      logical, intent(in) :: do_giss_phenology
      logical, intent(in) :: do_giss_lai
      logical, intent(in) :: do_giss_albedo
      !---
      !!!real*8, allocatable :: cropsdata_loc(:,:)
      real*8, pointer :: laidata_1(:), hdata_1(:),
     &     albedodata_1(:,:), cropsdata_1
      integer :: hemi_1, jday_1
      logical :: do_giss_phenology_1, do_giss_lai_1, do_giss_albedo_1
      logical :: init_1
      integer i1
      integer dims(2,1)

      dims(1,:) = lbound(entcell)
      dims(2,:) = ubound(entcell)

      ! set defaults
      nullify( laidata_1, hdata_1, albedodata_1, cropsdata_1 )
      do_giss_phenology_1 = .false.
      do_giss_lai_1 = .true.
      do_giss_albedo_1 = .false.
      hemi_1 = -32768
      jday_1 = -32768
      init_1 = .false.

      ! now set optional arguments
          do_giss_phenology_1 = do_giss_phenology
          do_giss_lai_1 = do_giss_lai
          do_giss_albedo_1 = do_giss_albedo
          jday_1 = jday
         
      
      do i1=dims(1,1),dims(2,1)
          ! skip uninitialized cells (no land)
        if ( associated(entcell(i1)%entcell) ) then

           hemi_1 = hemi(i1)
!          write(780,*) __FILE__,__LINE__,hemi_1
          
          call entcell_vegupdate(entcell(i1)%entcell,
     &         hemi_1,
     &         jday_1, do_giss_phenology_1, do_giss_lai_1,
     &         do_giss_albedo_1,
     &         laidata_1, hdata_1, albedodata_1, cropsdata_1,
     &         init_1)
        endif
      
      enddo

      end subroutine ent_prescribe_vegupdateC_r8_1

      subroutine ent_prescribe_vegupdateC_r8_2(entcell
     &     ,hemi,jday,year,
     &     do_giss_phenology, do_giss_albedo, do_giss_lai, 
     &     update_crops)
!@sum updates prescribed vegatation parameters. This parameters can
!@+   be passed directly in form of arrays like laidata or one can
!@+   set a flag requesting certain action like do_giss_phenology.
!@+   All arguments except entcell are optional.
      use ent_prescribed_updates, only:  entcell_vegupdate
      type(entcelltype_public),intent(inout) :: entcell (:,:)
      integer, intent(in), target :: hemi (:,:)
      integer,intent(in) :: jday,year
      logical, intent(in) :: update_crops
      logical, intent(in) :: do_giss_phenology
      logical, intent(in) :: do_giss_lai
      logical, intent(in) :: do_giss_albedo
      !---
      !!!real*8, allocatable :: cropsdata_loc(:,:)
      real*8, pointer :: laidata_1(:), hdata_1(:),
     &     albedodata_1(:,:), cropsdata_1
      integer :: hemi_1, jday_1
      logical :: do_giss_phenology_1, do_giss_lai_1, do_giss_albedo_1
      logical :: init_1
      integer i1,i2
      integer dims(2,2)

      dims(1,:) = lbound(entcell)
      dims(2,:) = ubound(entcell)

      ! set defaults
      nullify( laidata_1, hdata_1, albedodata_1, cropsdata_1 )
      do_giss_phenology_1 = .false.
      do_giss_lai_1 = .true.
      do_giss_albedo_1 = .false.
      hemi_1 = -32768
      jday_1 = -32768
      init_1 = .false.

      ! now set optional arguments
          do_giss_phenology_1 = do_giss_phenology
          do_giss_lai_1 = do_giss_lai
          do_giss_albedo_1 = do_giss_albedo
          jday_1 = jday
         
      
      do i1=dims(1,1),dims(2,1)
      do i2=dims(1,2),dims(2,2)
          ! skip uninitialized cells (no land)
        if ( associated(entcell(i1,i2)%entcell) ) then

           hemi_1 = hemi(i1,i2)
!          write(780,*) __FILE__,__LINE__,hemi_1
          
          call entcell_vegupdate(entcell(i1,i2)%entcell,
     &         hemi_1,
     &         jday_1, do_giss_phenology_1, do_giss_lai_1,
     &         do_giss_albedo_1,
     &         laidata_1, hdata_1, albedodata_1, cropsdata_1,
     &         init_1)
        endif
      
      enddo
      enddo

      end subroutine ent_prescribe_vegupdateC_r8_2

     

      subroutine ent_prescribe_vegupdateD_r8_0(entcell,
     &     laidata, albedodata)
!@sum updates prescribed vegatation parameters. This parameters can
!@+   be passed directly in form of arrays like laidata or one can
!@+   set a flag requesting certain action like do_giss_phenology.
!@+   All arguments except entcell are optional.
      use ent_prescribed_updates, only:  entcell_vegupdate
      type(entcelltype_public),intent(inout) :: entcell 
      real*8, intent(in), optional, target ::
     &     laidata(:)
      real*8, intent(in), optional, target ::
     &     albedodata(:,:)
      !---
      !!!real*8, allocatable :: cropsdata_loc(:,:)
      real*8, pointer :: laidata_1(:), hdata_1(:),
     &     albedodata_1(:,:), cropsdata_1
      integer :: hemi_1, jday_1
      logical :: do_giss_phenology_1, do_giss_lai_1, do_giss_albedo_1
      logical :: init_1
      
      

      
      

      ! set defaults
      nullify( laidata_1, hdata_1, albedodata_1, cropsdata_1 )
      do_giss_phenology_1 = .false.
      do_giss_lai_1 = .true.
      do_giss_albedo_1 = .false.
      hemi_1 = -32768
      jday_1 = -32768
      init_1 = .false.

      ! now set optional arguments
      
          ! skip uninitialized cells (no land)
        if ( associated(entcell%entcell) ) then

          laidata_1 => laidata(:)
          albedodata_1 => albedodata(:,:)

!          write(780,*) __FILE__,__LINE__,hemi_1
          
          call entcell_vegupdate(entcell%entcell,
     &         hemi_1,
     &         jday_1, do_giss_phenology_1, do_giss_lai_1,
     &         do_giss_albedo_1,
     &         laidata_1, hdata_1, albedodata_1, cropsdata_1,
     &         init_1)
        endif
      

      end subroutine ent_prescribe_vegupdateD_r8_0

      subroutine ent_prescribe_vegupdateD_r8_1(entcell,
     &     laidata, albedodata)
!@sum updates prescribed vegatation parameters. This parameters can
!@+   be passed directly in form of arrays like laidata or one can
!@+   set a flag requesting certain action like do_giss_phenology.
!@+   All arguments except entcell are optional.
      use ent_prescribed_updates, only:  entcell_vegupdate
      type(entcelltype_public),intent(inout) :: entcell (:)
      real*8, intent(in), optional, target ::
     &     laidata(:,:)
      real*8, intent(in), optional, target ::
     &     albedodata(:,:,:)
      !---
      !!!real*8, allocatable :: cropsdata_loc(:,:)
      real*8, pointer :: laidata_1(:), hdata_1(:),
     &     albedodata_1(:,:), cropsdata_1
      integer :: hemi_1, jday_1
      logical :: do_giss_phenology_1, do_giss_lai_1, do_giss_albedo_1
      logical :: init_1
      integer i1
      integer dims(2,1)

      dims(1,:) = lbound(entcell)
      dims(2,:) = ubound(entcell)

      ! set defaults
      nullify( laidata_1, hdata_1, albedodata_1, cropsdata_1 )
      do_giss_phenology_1 = .false.
      do_giss_lai_1 = .true.
      do_giss_albedo_1 = .false.
      hemi_1 = -32768
      jday_1 = -32768
      init_1 = .false.

      ! now set optional arguments
      
      do i1=dims(1,1),dims(2,1)
          ! skip uninitialized cells (no land)
        if ( associated(entcell(i1)%entcell) ) then

          laidata_1 => laidata(:,i1)
          albedodata_1 => albedodata(:,:,i1)

!          write(780,*) __FILE__,__LINE__,hemi_1
          
          call entcell_vegupdate(entcell(i1)%entcell,
     &         hemi_1,
     &         jday_1, do_giss_phenology_1, do_giss_lai_1,
     &         do_giss_albedo_1,
     &         laidata_1, hdata_1, albedodata_1, cropsdata_1,
     &         init_1)
        endif
      
      enddo

      end subroutine ent_prescribe_vegupdateD_r8_1

      subroutine ent_prescribe_vegupdateD_r8_2(entcell,
     &     laidata, albedodata)
!@sum updates prescribed vegatation parameters. This parameters can
!@+   be passed directly in form of arrays like laidata or one can
!@+   set a flag requesting certain action like do_giss_phenology.
!@+   All arguments except entcell are optional.
      use ent_prescribed_updates, only:  entcell_vegupdate
      type(entcelltype_public),intent(inout) :: entcell (:,:)
      real*8, intent(in), optional, target ::
     &     laidata(:,:,:)
      real*8, intent(in), optional, target ::
     &     albedodata(:,:,:,:)
      !---
      !!!real*8, allocatable :: cropsdata_loc(:,:)
      real*8, pointer :: laidata_1(:), hdata_1(:),
     &     albedodata_1(:,:), cropsdata_1
      integer :: hemi_1, jday_1
      logical :: do_giss_phenology_1, do_giss_lai_1, do_giss_albedo_1
      logical :: init_1
      integer i1,i2
      integer dims(2,2)

      dims(1,:) = lbound(entcell)
      dims(2,:) = ubound(entcell)

      ! set defaults
      nullify( laidata_1, hdata_1, albedodata_1, cropsdata_1 )
      do_giss_phenology_1 = .false.
      do_giss_lai_1 = .true.
      do_giss_albedo_1 = .false.
      hemi_1 = -32768
      jday_1 = -32768
      init_1 = .false.

      ! now set optional arguments
      
      do i1=dims(1,1),dims(2,1)
      do i2=dims(1,2),dims(2,2)
          ! skip uninitialized cells (no land)
        if ( associated(entcell(i1,i2)%entcell) ) then

          laidata_1 => laidata(:,i1,i2)
          albedodata_1 => albedodata(:,:,i1,i2)

!          write(780,*) __FILE__,__LINE__,hemi_1
          
          call entcell_vegupdate(entcell(i1,i2)%entcell,
     &         hemi_1,
     &         jday_1, do_giss_phenology_1, do_giss_lai_1,
     &         do_giss_albedo_1,
     &         laidata_1, hdata_1, albedodata_1, cropsdata_1,
     &         init_1)
        endif
      
      enddo
      enddo

      end subroutine ent_prescribe_vegupdateD_r8_2

     

      subroutine ent_fast_processes_r8_0(entcell, dt )
      use ent, only : ent_biophysics
      type(entcelltype_public),intent(inout) :: entcell 
      real*8, intent(in) :: dt
      !---
      
      

      
      

      
        call ent_biophysics(dt, entcell%entcell,
     &     config)
      

      end subroutine ent_fast_processes_r8_0

      subroutine ent_fast_processes_r8_1(entcell, dt )
      use ent, only : ent_biophysics
      type(entcelltype_public),intent(inout) :: entcell (:)
      real*8, intent(in) :: dt
      !---
      integer i1
      integer dims(2,1)

      dims(1,:) = lbound(entcell)
      dims(2,:) = ubound(entcell)

      
      do i1=dims(1,1),dims(2,1)
        call ent_biophysics(dt, entcell(i1)%entcell,
     &     config)
      
      enddo

      end subroutine ent_fast_processes_r8_1

      subroutine ent_fast_processes_r8_2(entcell, dt )
      use ent, only : ent_biophysics
      type(entcelltype_public),intent(inout) :: entcell (:,:)
      real*8, intent(in) :: dt
      !---
      integer i1,i2
      integer dims(2,2)

      dims(1,:) = lbound(entcell)
      dims(2,:) = ubound(entcell)

      
      do i1=dims(1,1),dims(2,1)
      do i2=dims(1,2),dims(2,2)
        call ent_biophysics(dt, entcell(i1,i2)%entcell,
     &     config)
      
      enddo
      enddo

      end subroutine ent_fast_processes_r8_2



      subroutine ent_run_r8_0(entcell,dt,update_day)
      use ent, only : ent_integrate !ent_integrate_GISS
!!! it is not clear yet for me how this call will be implemented ...
!@sum this call updates variable that change on a long time scale.
!@+   Right now (before real dynamic vegetation is implemented)
!@+   it should perform prescribed seasonal update of vegatation
!@+   parameters (LAI, root fraction etc.)
!@+   I think extra input parameters needed here should be passed 
!@+   as formal parameters and not be packed into entcell structure.
!@+   It seems that for prescribed variation of vegeatation
!@+   parameters we need only "jday"
!@+   Is it OK from ESMF point of view?
      !use ent_driver, only : ent_update_veg_structure
      type(entcelltype_public),intent(inout) :: entcell 
      real*8, intent(in) :: dt !Time step (s)
      logical, intent(in) :: update_day
!      integer, intent(in) :: jday
      !---
      
      

      
      

      
        call ent_integrate(dt, entcell%entcell,
     &     update_day,config)
      

      end subroutine ent_run_r8_0

      subroutine ent_run_r8_1(entcell,dt,update_day)
      use ent, only : ent_integrate !ent_integrate_GISS
!!! it is not clear yet for me how this call will be implemented ...
!@sum this call updates variable that change on a long time scale.
!@+   Right now (before real dynamic vegetation is implemented)
!@+   it should perform prescribed seasonal update of vegatation
!@+   parameters (LAI, root fraction etc.)
!@+   I think extra input parameters needed here should be passed 
!@+   as formal parameters and not be packed into entcell structure.
!@+   It seems that for prescribed variation of vegeatation
!@+   parameters we need only "jday"
!@+   Is it OK from ESMF point of view?
      !use ent_driver, only : ent_update_veg_structure
      type(entcelltype_public),intent(inout) :: entcell (:)
      real*8, intent(in) :: dt !Time step (s)
      logical, intent(in) :: update_day
!      integer, intent(in) :: jday
      !---
      integer i1
      integer dims(2,1)

      dims(1,:) = lbound(entcell)
      dims(2,:) = ubound(entcell)

      
      do i1=dims(1,1),dims(2,1)
        call ent_integrate(dt, entcell(i1)%entcell,
     &     update_day,config)
      
      enddo

      end subroutine ent_run_r8_1

      subroutine ent_run_r8_2(entcell,dt,update_day)
      use ent, only : ent_integrate !ent_integrate_GISS
!!! it is not clear yet for me how this call will be implemented ...
!@sum this call updates variable that change on a long time scale.
!@+   Right now (before real dynamic vegetation is implemented)
!@+   it should perform prescribed seasonal update of vegatation
!@+   parameters (LAI, root fraction etc.)
!@+   I think extra input parameters needed here should be passed 
!@+   as formal parameters and not be packed into entcell structure.
!@+   It seems that for prescribed variation of vegeatation
!@+   parameters we need only "jday"
!@+   Is it OK from ESMF point of view?
      !use ent_driver, only : ent_update_veg_structure
      type(entcelltype_public),intent(inout) :: entcell (:,:)
      real*8, intent(in) :: dt !Time step (s)
      logical, intent(in) :: update_day
!      integer, intent(in) :: jday
      !---
      integer i1,i2
      integer dims(2,2)

      dims(1,:) = lbound(entcell)
      dims(2,:) = ubound(entcell)

      
      do i1=dims(1,1),dims(2,1)
      do i2=dims(1,2),dims(2,2)
        call ent_integrate(dt, entcell(i1,i2)%entcell,
     &     update_day,config)
      
      enddo
      enddo

      end subroutine ent_run_r8_2



      subroutine ent_vegcover_update_r8_0(entcell, jday, jyear)
      type(entcelltype_public),intent(inout) :: entcell 
      integer, intent(in) :: jday, jyear
      !---      
      
      

      
      
 
      
        ! no code for vegcover_update yet ...
      

      end subroutine ent_vegcover_update_r8_0

      subroutine ent_vegcover_update_r8_1(entcell, jday, jyear)
      type(entcelltype_public),intent(inout) :: entcell (:)
      integer, intent(in) :: jday, jyear
      !---      
      integer i1
      integer dims(2,1)

      dims(1,:) = lbound(entcell)
      dims(2,:) = ubound(entcell)
 
      
      do i1=dims(1,1),dims(2,1)
        ! no code for vegcover_update yet ...
      
      enddo

      end subroutine ent_vegcover_update_r8_1

      subroutine ent_vegcover_update_r8_2(entcell, jday, jyear)
      type(entcelltype_public),intent(inout) :: entcell (:,:)
      integer, intent(in) :: jday, jyear
      !---      
      integer i1,i2
      integer dims(2,2)

      dims(1,:) = lbound(entcell)
      dims(2,:) = ubound(entcell)
 
      
      do i1=dims(1,1),dims(2,1)
      do i2=dims(1,2),dims(2,2)
        ! no code for vegcover_update yet ...
      
      enddo
      enddo

      end subroutine ent_vegcover_update_r8_2


!---- END interfaces to run the model one time step ----

!---- Constructor / Destructor -------------------------------------------


      subroutine ent_cell_construct_r8_0(entcell)
      type(entcelltype_public),intent(inout) :: entcell 
      
      

      
      
 
      
        call entcell_construct( entcell%entcell )
      

      end subroutine ent_cell_construct_r8_0

      subroutine ent_cell_construct_r8_1(entcell)
      type(entcelltype_public),intent(inout) :: entcell (:)
      integer i1
      integer dims(2,1)

      dims(1,:) = lbound(entcell)
      dims(2,:) = ubound(entcell)
 
      
      do i1=dims(1,1),dims(2,1)
        call entcell_construct( entcell(i1)%entcell )
      
      enddo

      end subroutine ent_cell_construct_r8_1

      subroutine ent_cell_construct_r8_2(entcell)
      type(entcelltype_public),intent(inout) :: entcell (:,:)
      integer i1,i2
      integer dims(2,2)

      dims(1,:) = lbound(entcell)
      dims(2,:) = ubound(entcell)
 
      
      do i1=dims(1,1),dims(2,1)
      do i2=dims(1,2),dims(2,2)
        call entcell_construct( entcell(i1,i2)%entcell )
      
      enddo
      enddo

      end subroutine ent_cell_construct_r8_2



      subroutine ent_cell_destruct_r8_0(entcell)
      type(entcelltype_public),intent(inout) :: entcell 
      
      

      
      
 
      
        call entcell_destruct( entcell%entcell )
      

      end subroutine ent_cell_destruct_r8_0

      subroutine ent_cell_destruct_r8_1(entcell)
      type(entcelltype_public),intent(inout) :: entcell (:)
      integer i1
      integer dims(2,1)

      dims(1,:) = lbound(entcell)
      dims(2,:) = ubound(entcell)
 
      
      do i1=dims(1,1),dims(2,1)
        call entcell_destruct( entcell(i1)%entcell )
      
      enddo

      end subroutine ent_cell_destruct_r8_1

      subroutine ent_cell_destruct_r8_2(entcell)
      type(entcelltype_public),intent(inout) :: entcell (:,:)
      integer i1,i2
      integer dims(2,2)

      dims(1,:) = lbound(entcell)
      dims(2,:) = ubound(entcell)
 
      
      do i1=dims(1,1),dims(2,1)
      do i2=dims(1,2),dims(2,2)
        call entcell_destruct( entcell(i1,i2)%entcell )
      
      enddo
      enddo

      end subroutine ent_cell_destruct_r8_2




      subroutine ent_cell_nullify_r8_0(entcell)
      type(entcelltype_public),intent(inout):: entcell 
      
      

      
      

      
        nullify( entcell%entcell )
      

      end subroutine ent_cell_nullify_r8_0

      subroutine ent_cell_nullify_r8_1(entcell)
      type(entcelltype_public),intent(inout):: entcell (:)
      integer i1
      integer dims(2,1)

      dims(1,:) = lbound(entcell)
      dims(2,:) = ubound(entcell)

      
      do i1=dims(1,1),dims(2,1)
        nullify( entcell(i1)%entcell )
      
      enddo

      end subroutine ent_cell_nullify_r8_1

      subroutine ent_cell_nullify_r8_2(entcell)
      type(entcelltype_public),intent(inout):: entcell (:,:)
      integer i1,i2
      integer dims(2,2)

      dims(1,:) = lbound(entcell)
      dims(2,:) = ubound(entcell)

      
      do i1=dims(1,1),dims(2,1)
      do i2=dims(1,2),dims(2,2)
        nullify( entcell(i1,i2)%entcell )
      
      enddo
      enddo

      end subroutine ent_cell_nullify_r8_2


!---- END of  Constructor / Destructor -----

!*************************************************************************


      subroutine ent_cell_set_r8_0(entcell,
     &     veg_fraction,
     &     pft_population_density,
     &     leaf_area_index,
     &     pft_heights,
     &     pft_dbh,
     &     pft_crad,
     &     pft_cpool,
     &     pft_nmdata,
     &     pft_froots,
     &     pft_soil_type,
     &     vegalbedo,
     &     soil_texture,
     &     Ci_ini, CNC_ini, Tcan_ini, Qf_ini, Tpool_ini,  !added Tpool_ini for prescribing soil C, N pools -PK
     &     reinitialize)
      type(entcelltype_public),intent(inout)::
     &                            entcell
      real*8, dimension(:)  ::   ! dim=N_COVERTYPES, n
     &     veg_fraction,
     &     leaf_area_index,
     &     pft_heights,
     &     pft_dbh,
     &     pft_crad,
     &     pft_population_density
      real*8, dimension(:)  ::   ! dim=N_COVERTYPES
     &     pft_nmdata
      real*8, dimension(:,:) :: pft_cpool !Carbon pools in individuals
      real*8, dimension(:,:)  :: pft_froots
      integer, dimension(:)  :: pft_soil_type
      real*8, dimension(:,:)  ::  vegalbedo ! dim=N_COVERTYPES, n
      real*8, dimension(:)  ::  soil_texture ! dim=N_SOIL_TEXTURES
      real*8  ::
     &     Ci_ini, CNC_ini, Tcan_ini, Qf_ini
      real*8,dimension(:,:,:,:) :: Tpool_ini  !soil pools, in g/m2 -PK
      logical :: reinitialize
      !---
      
      

      
      

      
          !print *,"ent_cell_set_array_2d i,j=",i,j
        if ( associated(entcell%entcell) ) then
!      if ( .not. associated(ecp) ) 
!     &      call stop_model("init_simple_entcell 1",255)
          !call entcell_print(6,entcell%entcell)

          call init_simple_entcell( entcell%entcell,
     &         veg_fraction(:),
     &         pft_population_density(:),
     &         leaf_area_index(:),
     &         pft_heights(:),
     &         pft_dbh(:),
     &         pft_crad(:),
     &         pft_cpool(:,:),
     &         pft_nmdata,
     &         pft_froots,
     &         pft_soil_type,vegalbedo(:,:),
     &         soil_texture(:),
     &         Ci_ini, CNC_ini,
     &         Tcan_ini, Qf_ini,
     &         Tpool_ini(:,:,:,:),
     &         reinitialize)
        endif
      

      end subroutine ent_cell_set_r8_0

      subroutine ent_cell_set_r8_1(entcell,
     &     veg_fraction,
     &     pft_population_density,
     &     leaf_area_index,
     &     pft_heights,
     &     pft_dbh,
     &     pft_crad,
     &     pft_cpool,
     &     pft_nmdata,
     &     pft_froots,
     &     pft_soil_type,
     &     vegalbedo,
     &     soil_texture,
     &     Ci_ini, CNC_ini, Tcan_ini, Qf_ini, Tpool_ini,  !added Tpool_ini for prescribing soil C, N pools -PK
     &     reinitialize)
      type(entcelltype_public),intent(inout)::
     &                            entcell(:)
      real*8, dimension(:,:)  ::   ! dim=N_COVERTYPES, n
     &     veg_fraction,
     &     leaf_area_index,
     &     pft_heights,
     &     pft_dbh,
     &     pft_crad,
     &     pft_population_density
      real*8, dimension(:)  ::   ! dim=N_COVERTYPES
     &     pft_nmdata
      real*8, dimension(:,:,:) :: pft_cpool !Carbon pools in individuals
      real*8, dimension(:,:)  :: pft_froots
      integer, dimension(:)  :: pft_soil_type
      real*8, dimension(:,:,:)  ::  vegalbedo ! dim=N_COVERTYPES, n
      real*8, dimension(:,:)  ::  soil_texture ! dim=N_SOIL_TEXTURES
      real*8 ,dimension(:) ::
     &     Ci_ini, CNC_ini, Tcan_ini, Qf_ini
      real*8,dimension(:,:,:,:,:) :: Tpool_ini  !soil pools, in g/m2 -PK
      logical :: reinitialize
      !---
      integer i1
      integer dims(2,1)

      dims(1,:) = lbound(entcell)
      dims(2,:) = ubound(entcell)

      
      do i1=dims(1,1),dims(2,1)
          !print *,"ent_cell_set_array_2d i,j=",i,j
        if ( associated(entcell(i1)%entcell) ) then
!      if ( .not. associated(ecp) ) 
!     &      call stop_model("init_simple_entcell 1",255)
          !call entcell_print(6,entcell(i1)%entcell)

          call init_simple_entcell( entcell(i1)%entcell,
     &         veg_fraction(:,i1),
     &         pft_population_density(:,i1),
     &         leaf_area_index(:,i1),
     &         pft_heights(:,i1),
     &         pft_dbh(:,i1),
     &         pft_crad(:,i1),
     &         pft_cpool(:,:,i1),
     &         pft_nmdata,
     &         pft_froots,
     &         pft_soil_type,vegalbedo(:,:,i1),
     &         soil_texture(:,i1),
     &         Ci_ini(i1), CNC_ini(i1),
     &         Tcan_ini(i1), Qf_ini(i1),
     &         Tpool_ini(:,:,:,:,i1),
     &         reinitialize)
        endif
      
      enddo

      end subroutine ent_cell_set_r8_1

      subroutine ent_cell_set_r8_2(entcell,
     &     veg_fraction,
     &     pft_population_density,
     &     leaf_area_index,
     &     pft_heights,
     &     pft_dbh,
     &     pft_crad,
     &     pft_cpool,
     &     pft_nmdata,
     &     pft_froots,
     &     pft_soil_type,
     &     vegalbedo,
     &     soil_texture,
     &     Ci_ini, CNC_ini, Tcan_ini, Qf_ini, Tpool_ini,  !added Tpool_ini for prescribing soil C, N pools -PK
     &     reinitialize)
      type(entcelltype_public),intent(inout)::
     &                            entcell(:,:)
      real*8, dimension(:,:,:)  ::   ! dim=N_COVERTYPES, n
     &     veg_fraction,
     &     leaf_area_index,
     &     pft_heights,
     &     pft_dbh,
     &     pft_crad,
     &     pft_population_density
      real*8, dimension(:)  ::   ! dim=N_COVERTYPES
     &     pft_nmdata
      real*8, dimension(:,:,:,:) :: pft_cpool !Carbon pools in individuals
      real*8, dimension(:,:)  :: pft_froots
      integer, dimension(:)  :: pft_soil_type
      real*8, dimension(:,:,:,:)  ::  vegalbedo ! dim=N_COVERTYPES, n
      real*8, dimension(:,:,:)  ::  soil_texture ! dim=N_SOIL_TEXTURES
      real*8 ,dimension(:,:) ::
     &     Ci_ini, CNC_ini, Tcan_ini, Qf_ini
      real*8,dimension(:,:,:,:,:,:) :: Tpool_ini  !soil pools, in g/m2 -PK
      logical :: reinitialize
      !---
      integer i1,i2
      integer dims(2,2)

      dims(1,:) = lbound(entcell)
      dims(2,:) = ubound(entcell)

      
      do i1=dims(1,1),dims(2,1)
      do i2=dims(1,2),dims(2,2)
          !print *,"ent_cell_set_array_2d i,j=",i,j
        if ( associated(entcell(i1,i2)%entcell) ) then
!      if ( .not. associated(ecp) ) 
!     &      call stop_model("init_simple_entcell 1",255)
          !call entcell_print(6,entcell(i1,i2)%entcell)

          call init_simple_entcell( entcell(i1,i2)%entcell,
     &         veg_fraction(:,i1,i2),
     &         pft_population_density(:,i1,i2),
     &         leaf_area_index(:,i1,i2),
     &         pft_heights(:,i1,i2),
     &         pft_dbh(:,i1,i2),
     &         pft_crad(:,i1,i2),
     &         pft_cpool(:,:,i1,i2),
     &         pft_nmdata,
     &         pft_froots,
     &         pft_soil_type,vegalbedo(:,:,i1,i2),
     &         soil_texture(:,i1,i2),
     &         Ci_ini(i1,i2), CNC_ini(i1,i2),
     &         Tcan_ini(i1,i2), Qf_ini(i1,i2),
     &         Tpool_ini(:,:,:,:,i1,i2),
     &         reinitialize)
        endif
      
      enddo
      enddo

      end subroutine ent_cell_set_r8_2


!*************************************************************************

      subroutine ent_cell_pack_2d(dbuf, entcell)
!@sum allocate single linear arrays dbuf and pack contents of
!@+   entcells(i,j) into it
      real*8, pointer :: dbuf(:)
      type(entcelltype_public), intent(in) :: entcell(:,:)
      !---
      type real8_ptr
        real*8, pointer :: ptr(:)
      end type real8_ptr
      type(real8_ptr), dimension(:,:), allocatable :: buf2d
      integer i, j, ic, jc, dc, dcc, lsize

      ic = size(entcell, 1)
      jc = size(entcell, 2)

      allocate( buf2d(ic,jc) )
      
      dc = 0
      do j=1,jc
        do i=1,ic
          !print *,"ent_cell_pack_2d i,j=",i,j
          nullify( buf2d(i,j)%ptr )
          if ( .not. associated(entcell(i,j)%entcell) ) cycle

          call ent_cell_pack(buf2d(i,j)%ptr, entcell(i,j))
          dc = dc + size(buf2d(i,j)%ptr, 1) + 3 ! 3 =: i,j,size
          
        enddo
      enddo

      allocate( dbuf(dc) )
      dcc = 1
      do j=1,jc
        do i=1,ic
          if ( .not. associated( buf2d(i,j)%ptr ) ) cycle

          !print *,"ent_cell_pack_2d i,j,dcc,lsize=",i,j,dcc,lsize
          !print *,buf2d(i,j)%ptr(1:lsize)
          lsize = size(buf2d(i,j)%ptr, 1)
          dbuf(dcc) = i; dcc = dcc+1
          dbuf(dcc) = j; dcc = dcc+1
          dbuf(dcc) = lsize; dcc = dcc+1
          dbuf(dcc:dcc+lsize-1) = buf2d(i,j)%ptr(1:lsize)
          dcc = dcc+lsize
          deallocate( buf2d(i,j)%ptr )

        enddo
      enddo

      if ( dcc-1 .ne. dc ) call stop_model("ent_cell_pack_2d: dcc",255)
     
      deallocate( buf2d )

      end subroutine ent_cell_pack_2d


      subroutine ent_cell_pack(dbuf, entcell)
!@sum allocate single linear arrays dbuf and pack contents of
!@+   entcell into it
      real*8, pointer :: dbuf(:)
      type(entcelltype_public), intent(in) :: entcell ! pointer ?
      !---
      type(entcelltype), pointer :: ecp
      type(patch), pointer :: p  !@var p current patch
      type(cohort), pointer :: c !@var current cohort
      integer :: np              !@var np number of patches in the cell
      integer :: nc(MAX_PATCHES) !@var nc number of cohorts in the patch
      integer :: dc, ndbuf, nn
      real*8 :: dummy(0)

      ! return "-1" for not associated cells
      if ( .not. associated(entcell%entcell) ) then
        allocate( dbuf(1) )
        dbuf(1) = -1.d0;
        return
      endif

      ecp => entcell%entcell

      ! first compute number of patches and cohorts in the cell
      ! this actually can be save in the cell structure 
      ! for optimization ...
      ! also count the number of real*8 values to be saved
      ndbuf = 0
      call copy_cell_vars(dummy, nn, ecp, 0); ndbuf = ndbuf + nn
      np = 0
      p => entcell%entcell%oldest      
      do while ( associated(p) )
        np = np + 1
        if ( np > MAX_PATCHES )
     &       call stop_model("ent_cell_pack: too many patches",255)
        call copy_patch_vars(dummy, nn, p, 0); ndbuf = ndbuf + nn
        nc(np) = 0
        c => p%tallest
        do while ( associated(c) )
          nc(np) = nc(np) + 1
          if ( nc(np) > MAX_COHORTS )
     &         call stop_model("ent_cell_pack: too many cohorts",255)
          !save cohort
          !dbuf(dc) = c%_any_value_ ; dc = dc + 1
          call copy_cohort_vars(dummy, nn, c, 0); ndbuf = ndbuf + nn
          c => c%shorter
        enddo
        p => p%younger
      enddo

      allocate( dbuf(ndbuf+1+np) ) !i.e. num reals + num int's
      dc = 0
      dbuf(dc+1) = real( np, kind(0d0) );               dc = dc + 1
      !print *,"pack ", np, dbuf(1)
      dbuf(dc+1:dc+np) = real( nc(1:np), kind(0d0) ); dc = dc + np
      !print *,"pack1 ", nc(1:np), dbuf(2:dc) 

      ! now do the real saving
      ! no need to count patches and cohorts again, but leaving it here
      ! for a while for debugging
      ! save cell vars here (if there are any...), i.e. 
      ! call copy_cell_vars(dbuf, nn, p, -1);
      call copy_cell_vars(dbuf(dc+1:), nn, ecp, -1); dc = dc + nn
      np = 0
      p => entcell%entcell%oldest      
      do while ( associated(p) )
        np = np + 1
        if ( np > MAX_PATCHES )
     &       call stop_model("ent_cell_pack: too many patches",255)
        !save patch
        call copy_patch_vars(dbuf(dc+1:), nn, p, -1); dc = dc + nn
        nc(np) = 0
        c => p%tallest
        do while ( associated(c) )
          nc(np) = nc(np) + 1
          if ( nc(np) > MAX_COHORTS )
     &         call stop_model("ent_cell_pack: too many cohorts",255)
          !save cohort
          call copy_cohort_vars(dbuf(dc+1:), nn, c, -1); dc = dc + nn
         c => c%shorter
        enddo
        p => p%younger
      enddo

      if ( dbuf(1) .ne. np ) then
        print *,"GGGGGGGGGGG", np, nc(1:np), "XX", dbuf
      endif

      end subroutine ent_cell_pack

!*************************************************************************

      subroutine ent_cell_unpack(dbuf, entcell)
! this program is not finished yet: have to assign all the pointers
      use cohorts, only : cohort_construct
      use patches, only : patch_construct
      real*8, intent(inout) :: dbuf(0:)
      type(entcelltype_public), intent(inout) :: entcell ! pointer ?
      !---
      type(entcelltype), pointer :: ecp
      type(patch), pointer :: p, pprev  !@var p current patch
      type(cohort), pointer :: c, cprev !@var current cohort
      integer :: np              !@var np number of patches in the cell
      integer, allocatable :: nc(:) !@var nc number of cohorts in the patch
      integer dc, nn
      integer i, j
      integer npdebug, ncdebug ! these are for debuging

      dc = 0

      ! doesn't seem that we need to restore anything for the cell
      np = nint( dbuf(dc) ); dc = dc + 1
      if ( np == -1 ) return  ! no data for this cell

      allocate( nc(np) )
      nc(1:np) = nint( dbuf(dc:dc+np-1) ); dc = dc + np

      if ( np <= 0 ) return  ! nothing to restore...

      ecp => entcell%entcell

      call copy_cell_vars(dbuf(dc:), nn, ecp, 1); dc = dc + nn
      nullify( pprev )
      do i=1,np
        !allocate( p )
        call patch_construct(p, entcell%entcell, 0.d0, -1)
        call copy_patch_vars(dbuf(dc:), nn, p, 1); dc = dc + nn
        p%older => pprev
        nullify( cprev)
        do j=1,nc(i)
          !allocate( c )
          call cohort_construct(c, p)
          call copy_cohort_vars(dbuf(dc:), nn, c, 1); dc = dc + nn
          c%taller => cprev
          cprev => c
        enddo
        p%shortest => cprev
        pprev => p
      enddo
      entcell%entcell%youngest => p

      ! now restore pointer lists in opposite direction
      npdebug = 0
      nullify( pprev )
      p => entcell%entcell%youngest
      do while ( associated(p) )
        p%younger => pprev
        p%cellptr => entcell%entcell
        npdebug = npdebug + 1
        if ( npdebug > np )
     &       call stop_model("ent_cell_unpack: broken struct: np",255)
        ncdebug = 0
        nullify( cprev)
        c => p%shortest
        do while ( associated(c) )
          c%shorter => cprev
          c%pptr => p
          c%cellptr => entcell%entcell
          ncdebug = ncdebug + 1
          if ( ncdebug > nc(np-npdebug+1) )
     &         call stop_model("ent_cell_unpack: broken struct: nc",255)
          cprev => c
          c => c%taller
        enddo
        p%tallest => cprev
        pprev => p
        p => p%older
      enddo
      entcell%entcell%oldest => pprev

      deallocate( nc )

      call summarize_entcell(entcell%entcell)

      end subroutine ent_cell_unpack

!*************************************************************************

      subroutine copy_vars_single( buf, n, var, flag )
!@copy variable to/from buffer
!@+   !!! may need to write similar for arrays and create an interface
!@+   !!! in that case "n" will have non-trivial value
      real*8, intent(inout) :: buf(:)
      integer, intent(inout) :: n
      real*8, intent(inout):: var
!@var flag defines the actual action:
!@+     -1 copy from var to buffer
!@+      1 copy from buffer to var
!@+      0 do nothing - just return the cumulative number of elements
      integer, intent(in) :: flag
      !---
      
      n = n + 1
      if ( flag == 0 ) return

      if ( flag == -1 ) then
        buf(n) = var
      else if ( flag == 1 ) then
        var = buf(n)
      else
        call stop_model("ent_mod:copy_vars: flag .ne. 0,-1,1",255)
      endif

      end subroutine copy_vars_single

      subroutine copy_vars_array( buf, n, var, flag )
!@copy variable to/from buffer
!@+   !!! may need to write similar for arrays and create an interface
!@+   !!! in that case "n" will have non-triial value
      real*8, intent(inout) :: buf(:)
      integer, intent(inout) :: n
      real*8, intent(inout):: var(:)
!@var flag defines the actual action:
!@+     -1 copy from var to buffer
!@+      1 copy from buffer to var
!@+      0 do nothing - just return the number of fields
      integer, intent(in) :: flag
      !---
      integer :: n0
      
      n0 = n + 1
      n = n + size(var)

      if ( flag == 0 ) return

      
      if ( flag == -1 ) then
        buf(n0:n) = var(:)
      else if ( flag == 1 ) then
        var(:) = buf(n0:n)
      else
        call stop_model("ent_mod:copy_vars: flag .ne. 0,-1,1",255)
      endif

      end subroutine copy_vars_array

      subroutine copy_vars_i_single( buf, n, var, flag )
!@copy variable to/from buffer
!@+   !!! may need to write similar for arrays and create an interface
!@+   !!! in that case "n" will have non-triial value
      real*8, intent(inout) :: buf(:)
      integer, intent(inout) :: n
      integer, intent(inout):: var
!@var flag defines the actual action:
!@+     -1 copy from var to buffer
!@+      1 copy from buffer to var
!@+      0 do nothing - just return the number of fields
      integer, intent(in) :: flag
      !---
      
      n = n + 1
      if ( flag == 0 ) return

      if ( flag == -1 ) then
        buf(n) = real( var, kind(buf) )
      else if ( flag == 1 ) then
        var = nint( buf(n) )
      else
        call stop_model("ent_mod:copy_vars: flag .ne. 0,-1,1",255)
      endif

      end subroutine copy_vars_i_single

      subroutine copy_vars_i_array( buf, n, var, flag )
!@copy variable to/from buffer
!@+   !!! may need to write similar for arrays and create an interface
!@+   !!! in that case "n" will have non-triial value
      real*8, intent(inout) :: buf(:)
      integer, intent(inout) :: n
      integer, intent(inout):: var(:)
!@var flag defines the actual action:
!@+     -1 copy from var to buffer
!@+      1 copy from buffer to var
!@+      0 do nothing - just return the number of fields
      integer, intent(in) :: flag
      !---
      integer :: n0
      
      n0 = n + 1
      n = n + size(var)
      if ( flag == 0 ) return

      if ( flag == -1 ) then
        buf(n0:n) = real( var(:), kind(buf))
      else if ( flag == 1 ) then
        var(:) = nint( buf(n0:n) )
      else
        call stop_model("ent_mod:copy_vars: flag .ne. 0,-1,1",255)
      endif

      end subroutine copy_vars_i_array

!*************************************************************************

!**************************************************************
!   the following two functions are all that user has to modify
!   when the list of i/o variables is changed
!   I wrote it in such a complicated way so that the list of
!   i/o variable appears only once (and is used both for input
!   and output). This prevents possible confusion due to
!   non-synchronized input and output lists.

!   i didn't include any i/o sub for cell since it looks like 
!   patch will not have any i/o vars


      subroutine copy_cell_vars(buf, n, entcell, flag)
      real*8, intent(inout) :: buf(0:)
      integer, intent(out) :: n
      !type(patch), intent(inout):: p
      type(entcelltype), intent(inout) :: entcell ! pointer ?
!@var flag defines the actual action:
!@+     -1 copy from patch to buffer
!@+      1 copy from buffer to patch
!@+      0 do nothing - just return the number of fields
      integer, intent(in) :: flag
      !---
      integer dc, nn, i

      dc = 0

      ! include all cell variables that need i/o
      ! actually soil_texture is BC, but store it to checkpoint for now ...
      call copy_vars( buf, dc, entcell%soil_texture, flag)

      ! the following vars are from clim_stats 
      ! do we really need them ??
      call copy_vars( buf, dc, entcell%soiltemp_10d, flag)
      call copy_vars( buf, dc, entcell%airtemp_10d, flag)
      call copy_vars( buf, dc, entcell%paw_10d, flag)
      call copy_vars( buf, dc, entcell%par_10d, flag)
      call copy_vars( buf, dc, entcell%gdd, flag)
      call copy_vars( buf, dc, entcell%ncd, flag)
      call copy_vars( buf, dc, entcell%ld, flag)

      n = dc

      end subroutine copy_cell_vars


      subroutine copy_patch_vars(buf, n, p, flag)
      real*8, intent(inout) :: buf(0:)
      integer, intent(out) :: n
      type(patch), intent(inout):: p
!@var flag defines the actual action:
!@+     -1 copy from patch to buffer
!@+      1 copy from buffer to patch
!@+      0 do nothing - just return the number of fields
      integer, intent(in) :: flag
      !---
      integer dc, nn, i

      dc = 0

      ! include all patch variables that need i/o
      call copy_vars( buf, dc,  p%age,  flag )
      call copy_vars( buf, dc,  p%area, flag )
      call copy_vars( buf, dc,  p%Ci,   flag )
      do i=1,N_CASA_LAYERS      !need b/c Tpool now rank 3  -PK  
       call copy_vars( buf, dc,  p%Tpool(1,:,i),flag )
       call copy_vars( buf, dc,  p%Tpool(2,:,i),flag )
      end do
      ! not sure about the following, probably can be restored from 
      ! other data...
      call copy_vars( buf, dc,  p%soil_type, flag )
      call copy_vars( buf, dc,  p%GCANOPY, flag )
      call copy_vars( buf, dc,  p%albedo, flag )

      n = dc

      end subroutine copy_patch_vars


      subroutine copy_cohort_vars(buf, n, c, flag)
      real*8, intent(inout) :: buf(0:)
      integer, intent(out) :: n
      type(cohort), intent(inout):: c
!@var flag defines the actual action:
!@+     -1 copy from patch to buffer
!@+      1 copy from buffer to patch
!@+      0 do nothing - just return the number of fields
      integer, intent(in) :: flag
      !---
      integer dc, nn

      dc = 0

      ! include all cohort variables that need i/o
      call copy_vars( buf, dc,  c%pft,  flag )
      call copy_vars( buf, dc,  c%n,    flag )
      call copy_vars( buf, dc,  c%nm,   flag )
      call copy_vars( buf, dc,  c%lai,  flag )
      call copy_vars( buf, dc,  c%h,    flag )
      call copy_vars( buf, dc,  c%dbh,  flag )
!      call copy_vars( buf, dc,  c%_any_var2_, flag )
      ! data for Tpool, do we need these?
      call copy_vars( buf, dc,  c%C_fol,  flag )
      call copy_vars( buf, dc,  c%C_froot,  flag )
      call copy_vars( buf, dc,  c%C_hw,  flag )
      ! I guess fracroot is also needed ...
      call copy_vars( buf, dc,  c%fracroot,  flag )

      ! added new data to restore checkpoint after sumcohort was removed...
      call copy_vars( buf, dc,  c%Ci,  flag )
      call copy_vars( buf, dc,  c%gcanopy,  flag )

      ! new data jan 10 2008
      call copy_vars( buf, dc,  c%C_fol   ,  flag )
      call copy_vars( buf, dc,  c%N_fol   ,  flag )
      call copy_vars( buf, dc,  c%C_sw    ,  flag )
      call copy_vars( buf, dc,  c%N_sw    ,  flag )
      call copy_vars( buf, dc,  c%C_hw    ,  flag )
      call copy_vars( buf, dc,  c%N_hw    ,  flag )
      call copy_vars( buf, dc,  c%C_lab   ,  flag )
      call copy_vars( buf, dc,  c%N_lab   ,  flag )
      call copy_vars( buf, dc,  c%C_froot ,  flag )
      call copy_vars( buf, dc,  c%N_froot ,  flag )
      call copy_vars( buf, dc,  c%C_croot ,  flag )
      call copy_vars( buf, dc,  c%N_croot ,  flag )

      ! diags and hacks (added dec 9 2008)
      call copy_vars( buf, dc,  c%C_growth,  flag )
      call copy_vars( buf, dc,  c%C_total ,  flag )
      ! added on Mar 30 2009. Do we really need this?
      call copy_vars( buf, dc,  c%llspan  ,  flag )
      call copy_vars( buf, dc,  c%turnover_amp,  flag )
      ! needed for frost hardiness ?
      call copy_vars( buf, dc,  c%Sacclim ,  flag )

      n = dc

      end subroutine copy_cohort_vars

!******************************************************************




      subroutine ent_set_forcings_r8_0( entcell,
     &     air_temperature, !KIM - for phenology
     &     canopy_temperature,
     &     canopy_air_humidity,      
     &     surf_pressure,            
     &     surf_CO2,                 
     &     heat_transfer_coef,       
     &     wind_speed,               
     &     total_visible_rad,
     &     direct_visible_rad,
     &     cos_solar_zenith_angle,
     &     canopy_wet_fraction,
!     &     soil_temp30cm,
!     &     soil_moist30cm,
     &     soil_temp,
     &     soil_moist,
!     &     soil_water,
     &     soil_matric_pot,
     &     soil_ice_fraction
     &     ) ! need to pass Ci, Qf ??
      type(entcelltype_public),intent(inout):: entcell
      ! forcings probably should not be optional ...
      real*8 , intent(in)  ::
     &     air_temperature, !KIM - for phenology
     &     canopy_temperature,
     &     canopy_air_humidity,
     &     surf_pressure,
     &     surf_CO2,
     &     heat_transfer_coef,
     &     wind_speed,
     &     total_visible_rad,
     &     direct_visible_rad,
     &     cos_solar_zenith_angle,
     &     canopy_wet_fraction
!     &     soil_temp30cm,
!     &     soil_moist30cm
      real*8, dimension(:), intent(in) ::
     &     soil_temp,
     &     soil_moist,
!     &     soil_water,
     &     soil_matric_pot,
     &     soil_ice_fraction
      !----------
      integer n
      
      

      
      
      
      !do j=1,jc
        !do i=1,ic
      
          entcell%entcell%TairC =
     &     air_temperature !KIM - for phenoloygy
          entcell%entcell%TcanopyC =
     &         canopy_temperature
          entcell%entcell%Qf =
     &         canopy_air_humidity
          entcell%entcell%P_mbar =
     &         surf_pressure
          entcell%entcell%Ca =
     &         surf_CO2
          entcell%entcell%Ch =
     &         heat_transfer_coef
          entcell%entcell%U =
     &         wind_speed
          entcell%entcell%IPARdif =
     &         total_visible_rad -
     &         direct_visible_rad
          entcell%entcell%IPARdir =
     &         direct_visible_rad
          entcell%entcell%CosZen =
     &         cos_solar_zenith_angle
          entcell%entcell%fwet_canopy =
     &         canopy_wet_fraction
!          entcell%entcell%Soiltemp =
!    &      soil_temp30cm
!          entcell%entcell%Soilmoist =
!    &         soil_moist30cm
          do n=1,N_CASA_LAYERS
            entcell%entcell%Soiltemp(n) =
     &           soil_temp(n)
            entcell%entcell%Soilmoist(n) =
     &           soil_moist(n)
          end do
          do n=1,N_DEPTH
            entcell%entcell%Soilmp(n) =
     &           soil_matric_pot(n)
            entcell%entcell%fice(n) =
     &           soil_ice_fraction(n)
          enddo
      
        !enddo
      !enddo

      end subroutine ent_set_forcings_r8_0

      subroutine ent_set_forcings_r8_1( entcell,
     &     air_temperature, !KIM - for phenology
     &     canopy_temperature,
     &     canopy_air_humidity,      
     &     surf_pressure,            
     &     surf_CO2,                 
     &     heat_transfer_coef,       
     &     wind_speed,               
     &     total_visible_rad,
     &     direct_visible_rad,
     &     cos_solar_zenith_angle,
     &     canopy_wet_fraction,
!     &     soil_temp30cm,
!     &     soil_moist30cm,
     &     soil_temp,
     &     soil_moist,
!     &     soil_water,
     &     soil_matric_pot,
     &     soil_ice_fraction
     &     ) ! need to pass Ci, Qf ??
      type(entcelltype_public),intent(inout):: entcell(:)
      ! forcings probably should not be optional ...
      real*8 ,dimension(:), intent(in)  ::
     &     air_temperature, !KIM - for phenology
     &     canopy_temperature,
     &     canopy_air_humidity,
     &     surf_pressure,
     &     surf_CO2,
     &     heat_transfer_coef,
     &     wind_speed,
     &     total_visible_rad,
     &     direct_visible_rad,
     &     cos_solar_zenith_angle,
     &     canopy_wet_fraction
!     &     soil_temp30cm,
!     &     soil_moist30cm
      real*8, dimension(:,:), intent(in) ::
     &     soil_temp,
     &     soil_moist,
!     &     soil_water,
     &     soil_matric_pot,
     &     soil_ice_fraction
      !----------
      integer n
      integer i1
      integer dims(2,1)

      dims(1,:) = lbound(entcell)
      dims(2,:) = ubound(entcell)
      
      !do j=1,jc
        !do i=1,ic
      
      do i1=dims(1,1),dims(2,1)
          entcell(i1)%entcell%TairC =
     &     air_temperature(i1) !KIM - for phenoloygy
          entcell(i1)%entcell%TcanopyC =
     &         canopy_temperature(i1)
          entcell(i1)%entcell%Qf =
     &         canopy_air_humidity(i1)
          entcell(i1)%entcell%P_mbar =
     &         surf_pressure(i1)
          entcell(i1)%entcell%Ca =
     &         surf_CO2(i1)
          entcell(i1)%entcell%Ch =
     &         heat_transfer_coef(i1)
          entcell(i1)%entcell%U =
     &         wind_speed(i1)
          entcell(i1)%entcell%IPARdif =
     &         total_visible_rad(i1) -
     &         direct_visible_rad(i1)
          entcell(i1)%entcell%IPARdir =
     &         direct_visible_rad(i1)
          entcell(i1)%entcell%CosZen =
     &         cos_solar_zenith_angle(i1)
          entcell(i1)%entcell%fwet_canopy =
     &         canopy_wet_fraction(i1)
!          entcell(i1)%entcell%Soiltemp =
!    &      soil_temp30cm(i1)
!          entcell(i1)%entcell%Soilmoist =
!    &         soil_moist30cm(i1)
          do n=1,N_CASA_LAYERS
            entcell(i1)%entcell%Soiltemp(n) =
     &           soil_temp(n,i1)
            entcell(i1)%entcell%Soilmoist(n) =
     &           soil_moist(n,i1)
          end do
          do n=1,N_DEPTH
            entcell(i1)%entcell%Soilmp(n) =
     &           soil_matric_pot(n,i1)
            entcell(i1)%entcell%fice(n) =
     &           soil_ice_fraction(n,i1)
          enddo
      
      enddo
        !enddo
      !enddo

      end subroutine ent_set_forcings_r8_1

      subroutine ent_set_forcings_r8_2( entcell,
     &     air_temperature, !KIM - for phenology
     &     canopy_temperature,
     &     canopy_air_humidity,      
     &     surf_pressure,            
     &     surf_CO2,                 
     &     heat_transfer_coef,       
     &     wind_speed,               
     &     total_visible_rad,
     &     direct_visible_rad,
     &     cos_solar_zenith_angle,
     &     canopy_wet_fraction,
!     &     soil_temp30cm,
!     &     soil_moist30cm,
     &     soil_temp,
     &     soil_moist,
!     &     soil_water,
     &     soil_matric_pot,
     &     soil_ice_fraction
     &     ) ! need to pass Ci, Qf ??
      type(entcelltype_public),intent(inout):: entcell(:,:)
      ! forcings probably should not be optional ...
      real*8 ,dimension(:,:), intent(in)  ::
     &     air_temperature, !KIM - for phenology
     &     canopy_temperature,
     &     canopy_air_humidity,
     &     surf_pressure,
     &     surf_CO2,
     &     heat_transfer_coef,
     &     wind_speed,
     &     total_visible_rad,
     &     direct_visible_rad,
     &     cos_solar_zenith_angle,
     &     canopy_wet_fraction
!     &     soil_temp30cm,
!     &     soil_moist30cm
      real*8, dimension(:,:,:), intent(in) ::
     &     soil_temp,
     &     soil_moist,
!     &     soil_water,
     &     soil_matric_pot,
     &     soil_ice_fraction
      !----------
      integer n
      integer i1,i2
      integer dims(2,2)

      dims(1,:) = lbound(entcell)
      dims(2,:) = ubound(entcell)
      
      !do j=1,jc
        !do i=1,ic
      
      do i1=dims(1,1),dims(2,1)
      do i2=dims(1,2),dims(2,2)
          entcell(i1,i2)%entcell%TairC =
     &     air_temperature(i1,i2) !KIM - for phenoloygy
          entcell(i1,i2)%entcell%TcanopyC =
     &         canopy_temperature(i1,i2)
          entcell(i1,i2)%entcell%Qf =
     &         canopy_air_humidity(i1,i2)
          entcell(i1,i2)%entcell%P_mbar =
     &         surf_pressure(i1,i2)
          entcell(i1,i2)%entcell%Ca =
     &         surf_CO2(i1,i2)
          entcell(i1,i2)%entcell%Ch =
     &         heat_transfer_coef(i1,i2)
          entcell(i1,i2)%entcell%U =
     &         wind_speed(i1,i2)
          entcell(i1,i2)%entcell%IPARdif =
     &         total_visible_rad(i1,i2) -
     &         direct_visible_rad(i1,i2)
          entcell(i1,i2)%entcell%IPARdir =
     &         direct_visible_rad(i1,i2)
          entcell(i1,i2)%entcell%CosZen =
     &         cos_solar_zenith_angle(i1,i2)
          entcell(i1,i2)%entcell%fwet_canopy =
     &         canopy_wet_fraction(i1,i2)
!          entcell(i1,i2)%entcell%Soiltemp =
!    &      soil_temp30cm(i1,i2)
!          entcell(i1,i2)%entcell%Soilmoist =
!    &         soil_moist30cm(i1,i2)
          do n=1,N_CASA_LAYERS
            entcell(i1,i2)%entcell%Soiltemp(n) =
     &           soil_temp(n,i1,i2)
            entcell(i1,i2)%entcell%Soilmoist(n) =
     &           soil_moist(n,i1,i2)
          end do
          do n=1,N_DEPTH
            entcell(i1,i2)%entcell%Soilmp(n) =
     &           soil_matric_pot(n,i1,i2)
            entcell(i1,i2)%entcell%fice(n) =
     &           soil_ice_fraction(n,i1,i2)
          enddo
      
      enddo
      enddo
        !enddo
      !enddo

      end subroutine ent_set_forcings_r8_2




      subroutine ent_get_exports_r8_0( entcell,
     &     canopy_conductance,
     &     beta_soil_layers,
     &     shortwave_transmit,
     &     leafinternal_CO2,
     &     foliage_humidity,
     &     canopy_gpp,
C NADINE
     &     canopy_ipp,
     &     roughness_length,
     &     flux_CO2,
     &     C_labile,
     &     R_auto,
     &     albedo,
     &     canopy_max_H2O,
     &     canopy_heat_capacity,
     &     canopy_height,
     &     fraction_of_vegetated_soil,
     &     vegetation_fractions,
     &     soilresp,
     &     soilcpools,
     &     leaf_area_index,
     &     C_total,
     &     C_entcell
     &     )
      type(entcelltype_public), intent(in) :: entcell
      real*8,  optional, intent(out) ::
     &     canopy_conductance,
     &     shortwave_transmit,
     &     leafinternal_CO2,
     &     foliage_humidity,
     &     canopy_gpp,
C NADINE
     &     canopy_ipp,
     &     roughness_length,
     &     flux_CO2,
     &     C_labile,
     &     R_auto,
     &     canopy_max_H2O,
     &     canopy_heat_capacity,
     &     canopy_height,
     &     fraction_of_vegetated_soil,
     &     soilresp,
     &     leaf_area_index,
     &     C_total,
     &     C_entcell
      real*8, dimension(:), optional, intent(out) ::
     &     beta_soil_layers,
     &     albedo,
     &     vegetation_fractions
      real*8, dimension(:,:,:), optional, intent(out) ::
     &     soilcpools
      !----------
      integer n,p,ii
      
      

      
      

      

      if ( present(canopy_conductance) )
     &     canopy_conductance = 
     &       entcell%entcell%GCANOPY

      !!! Nancy, do you really nedd this ???
      

      if ( present(shortwave_transmit) )
     &     shortwave_transmit = 
     &     entcell%entcell%TRANS_SW

      if ( present(leafinternal_CO2) )
     &     leafinternal_CO2 =
     &     entcell%entcell%Ci

      if ( present(foliage_humidity) )
     &     foliage_humidity =
     &     entcell%entcell%Qf

      if ( present(canopy_gpp) )
     &     canopy_gpp =
     &     entcell%entcell%GPP

C NADINE
      if ( present(canopy_ipp) )
     &     canopy_ipp =
     &     entcell%entcell%IPP

      if ( present(roughness_length) )
     &     roughness_length =
     &     entcell%entcell%z0

      if ( present(flux_CO2) )
     &     flux_CO2 =
     &     entcell%entcell%CO2flux

      if ( present(canopy_max_H2O) )
     &     canopy_max_H2O = 
     &     entcell%entcell%LAI * .0001d0 !!! GISS setting

      if ( present(canopy_heat_capacity) ) then
        !aa=ala(1,i0,j0)
        !canopy_heat_capacity=(.010d0+.002d0*aa+.001d0*aa**2)*shw
        canopy_heat_capacity =
     &       entcell%entcell%heat_capacity
        !call stop_model("not implemmented yet",255)
      endif

      if ( present(canopy_height) ) then
        canopy_height =
     &       entcell%entcell%h
      endif

      if ( present(fraction_of_vegetated_soil) ) then
        ! compute it here ?
        !call stop_model("not implemmented yet",255)
        if ( associated(entcell%entcell) ) then
          fraction_of_vegetated_soil =
     &         entcell%entcell%fv
        else
          fraction_of_vegetated_soil = 0.d0
        endif
      endif

      if ( present(C_labile) )
     &     C_labile =
     &     entcell%entcell%C_lab

      if ( present(R_auto) )
     &     R_auto =
     &     entcell%entcell%R_auto

      if ( present(soilresp) )
     &     soilresp =
     &     entcell%entcell%Soil_resp

      if ( present(beta_soil_layers) ) then
        do n=1,N_DEPTH
          beta_soil_layers(n) = 
     &         entcell%entcell%betadl(n)
        enddo
      endif

      if ( present(albedo) ) then
        do n=1,N_BANDS
          albedo(n) =
     &         entcell%entcell%albedo(n)
        enddo
      endif

      if ( present(vegetation_fractions) ) then
        call entcell_extract_pfts(entcell%entcell,
     &       vegetation_fractions(:))
      endif

      if ( present(soilcpools) ) then
        do n=1,N_CASA_LAYERS
         do p=1,PTRACE
          do ii=1,NPOOLS
            soilcpools(p,ii,n) = 
     &      entcell%entcell%Tpool(p,ii,n)
          end do
         end do
        enddo
      endif

      if ( present(leaf_area_index) )
     &     leaf_area_index = 
     &     entcell%entcell%LAI

      if ( present(C_total) )
     &     C_total = 
     &     entcell%entcell%C_total

      if ( present(C_entcell) ) then
        if ( associated(entcell%entcell) ) then
          C_entcell = 
     &     entcell_carbon( entcell%entcell )
        else
	  C_entcell = 0.d0
	endif
      endif 

      

      end subroutine ent_get_exports_r8_0

      subroutine ent_get_exports_r8_1( entcell,
     &     canopy_conductance,
     &     beta_soil_layers,
     &     shortwave_transmit,
     &     leafinternal_CO2,
     &     foliage_humidity,
     &     canopy_gpp,
C NADINE
     &     canopy_ipp,
     &     roughness_length,
     &     flux_CO2,
     &     C_labile,
     &     R_auto,
     &     albedo,
     &     canopy_max_H2O,
     &     canopy_heat_capacity,
     &     canopy_height,
     &     fraction_of_vegetated_soil,
     &     vegetation_fractions,
     &     soilresp,
     &     soilcpools,
     &     leaf_area_index,
     &     C_total,
     &     C_entcell
     &     )
      type(entcelltype_public), intent(in) :: entcell(:)
      real*8, dimension(:), optional, intent(out) ::
     &     canopy_conductance,
     &     shortwave_transmit,
     &     leafinternal_CO2,
     &     foliage_humidity,
     &     canopy_gpp,
C NADINE
     &     canopy_ipp,
     &     roughness_length,
     &     flux_CO2,
     &     C_labile,
     &     R_auto,
     &     canopy_max_H2O,
     &     canopy_heat_capacity,
     &     canopy_height,
     &     fraction_of_vegetated_soil,
     &     soilresp,
     &     leaf_area_index,
     &     C_total,
     &     C_entcell
      real*8, dimension(:,:), optional, intent(out) ::
     &     beta_soil_layers,
     &     albedo,
     &     vegetation_fractions
      real*8, dimension(:,:,:,:), optional, intent(out) ::
     &     soilcpools
      !----------
      integer n,p,ii
      integer i1
      integer dims(2,1)

      dims(1,:) = lbound(entcell)
      dims(2,:) = ubound(entcell)

      
      do i1=dims(1,1),dims(2,1)

      if ( present(canopy_conductance) )
     &     canopy_conductance(i1) = 
     &       entcell(i1)%entcell%GCANOPY

      !!! Nancy, do you really nedd this ???
      if( i1 > 32768 ) then
        print*,"Nancys compiler needs print stmt in ent_mod here"
      endif
      

      if ( present(shortwave_transmit) )
     &     shortwave_transmit(i1) = 
     &     entcell(i1)%entcell%TRANS_SW

      if ( present(leafinternal_CO2) )
     &     leafinternal_CO2(i1) =
     &     entcell(i1)%entcell%Ci

      if ( present(foliage_humidity) )
     &     foliage_humidity(i1) =
     &     entcell(i1)%entcell%Qf

      if ( present(canopy_gpp) )
     &     canopy_gpp(i1) =
     &     entcell(i1)%entcell%GPP

C NADINE
      if ( present(canopy_ipp) )
     &     canopy_ipp(i1) =
     &     entcell(i1)%entcell%IPP

      if ( present(roughness_length) )
     &     roughness_length(i1) =
     &     entcell(i1)%entcell%z0

      if ( present(flux_CO2) )
     &     flux_CO2(i1) =
     &     entcell(i1)%entcell%CO2flux

      if ( present(canopy_max_H2O) )
     &     canopy_max_H2O(i1) = 
     &     entcell(i1)%entcell%LAI * .0001d0 !!! GISS setting

      if ( present(canopy_heat_capacity) ) then
        !aa=ala(1,i0,j0)
        !canopy_heat_capacity=(.010d0+.002d0*aa+.001d0*aa**2)*shw
        canopy_heat_capacity(i1) =
     &       entcell(i1)%entcell%heat_capacity
        !call stop_model("not implemmented yet",255)
      endif

      if ( present(canopy_height) ) then
        canopy_height(i1) =
     &       entcell(i1)%entcell%h
      endif

      if ( present(fraction_of_vegetated_soil) ) then
        ! compute it here ?
        !call stop_model("not implemmented yet",255)
        if ( associated(entcell(i1)%entcell) ) then
          fraction_of_vegetated_soil(i1) =
     &         entcell(i1)%entcell%fv
        else
          fraction_of_vegetated_soil(i1) = 0.d0
        endif
      endif

      if ( present(C_labile) )
     &     C_labile(i1) =
     &     entcell(i1)%entcell%C_lab

      if ( present(R_auto) )
     &     R_auto(i1) =
     &     entcell(i1)%entcell%R_auto

      if ( present(soilresp) )
     &     soilresp(i1) =
     &     entcell(i1)%entcell%Soil_resp

      if ( present(beta_soil_layers) ) then
        do n=1,N_DEPTH
          beta_soil_layers(n,i1) = 
     &         entcell(i1)%entcell%betadl(n)
        enddo
      endif

      if ( present(albedo) ) then
        do n=1,N_BANDS
          albedo(n,i1) =
     &         entcell(i1)%entcell%albedo(n)
        enddo
      endif

      if ( present(vegetation_fractions) ) then
        call entcell_extract_pfts(entcell(i1)%entcell,
     &       vegetation_fractions(:,i1))
      endif

      if ( present(soilcpools) ) then
        do n=1,N_CASA_LAYERS
         do p=1,PTRACE
          do ii=1,NPOOLS
            soilcpools(p,ii,n,i1) = 
     &      entcell(i1)%entcell%Tpool(p,ii,n)
          end do
         end do
        enddo
      endif

      if ( present(leaf_area_index) )
     &     leaf_area_index(i1) = 
     &     entcell(i1)%entcell%LAI

      if ( present(C_total) )
     &     C_total(i1) = 
     &     entcell(i1)%entcell%C_total

      if ( present(C_entcell) ) then
        if ( associated(entcell(i1)%entcell) ) then
          C_entcell(i1) = 
     &     entcell_carbon( entcell(i1)%entcell )
        else
	  C_entcell(i1) = 0.d0
	endif
      endif 

      
      enddo

      end subroutine ent_get_exports_r8_1

      subroutine ent_get_exports_r8_2( entcell,
     &     canopy_conductance,
     &     beta_soil_layers,
     &     shortwave_transmit,
     &     leafinternal_CO2,
     &     foliage_humidity,
     &     canopy_gpp,
C NADINE
     &     canopy_ipp,
     &     roughness_length,
     &     flux_CO2,
     &     C_labile,
     &     R_auto,
     &     albedo,
     &     canopy_max_H2O,
     &     canopy_heat_capacity,
     &     canopy_height,
     &     fraction_of_vegetated_soil,
     &     vegetation_fractions,
     &     soilresp,
     &     soilcpools,
     &     leaf_area_index,
     &     C_total,
     &     C_entcell
     &     )
      type(entcelltype_public), intent(in) :: entcell(:,:)
      real*8, dimension(:,:), optional, intent(out) ::
     &     canopy_conductance,
     &     shortwave_transmit,
     &     leafinternal_CO2,
     &     foliage_humidity,
     &     canopy_gpp,
C NADINE
     &     canopy_ipp,
     &     roughness_length,
     &     flux_CO2,
     &     C_labile,
     &     R_auto,
     &     canopy_max_H2O,
     &     canopy_heat_capacity,
     &     canopy_height,
     &     fraction_of_vegetated_soil,
     &     soilresp,
     &     leaf_area_index,
     &     C_total,
     &     C_entcell
      real*8, dimension(:,:,:), optional, intent(out) ::
     &     beta_soil_layers,
     &     albedo,
     &     vegetation_fractions
      real*8, dimension(:,:,:,:,:), optional, intent(out) ::
     &     soilcpools
      !----------
      integer n,p,ii
      integer i1,i2
      integer dims(2,2)

      dims(1,:) = lbound(entcell)
      dims(2,:) = ubound(entcell)

      
      do i1=dims(1,1),dims(2,1)
      do i2=dims(1,2),dims(2,2)

      if ( present(canopy_conductance) )
     &     canopy_conductance(i1,i2) = 
     &       entcell(i1,i2)%entcell%GCANOPY

      !!! Nancy, do you really nedd this ???
      if( i1 > 32768 ) then
        print*,"Nancys compiler needs print stmt in ent_mod here"
      endif
      

      if ( present(shortwave_transmit) )
     &     shortwave_transmit(i1,i2) = 
     &     entcell(i1,i2)%entcell%TRANS_SW

      if ( present(leafinternal_CO2) )
     &     leafinternal_CO2(i1,i2) =
     &     entcell(i1,i2)%entcell%Ci

      if ( present(foliage_humidity) )
     &     foliage_humidity(i1,i2) =
     &     entcell(i1,i2)%entcell%Qf

      if ( present(canopy_gpp) )
     &     canopy_gpp(i1,i2) =
     &     entcell(i1,i2)%entcell%GPP

C NADINE
      if ( present(canopy_ipp) )
     &     canopy_ipp(i1,i2) =
     &     entcell(i1,i2)%entcell%IPP

      if ( present(roughness_length) )
     &     roughness_length(i1,i2) =
     &     entcell(i1,i2)%entcell%z0

      if ( present(flux_CO2) )
     &     flux_CO2(i1,i2) =
     &     entcell(i1,i2)%entcell%CO2flux

      if ( present(canopy_max_H2O) )
     &     canopy_max_H2O(i1,i2) = 
     &     entcell(i1,i2)%entcell%LAI * .0001d0 !!! GISS setting

      if ( present(canopy_heat_capacity) ) then
        !aa=ala(1,i0,j0)
        !canopy_heat_capacity=(.010d0+.002d0*aa+.001d0*aa**2)*shw
        canopy_heat_capacity(i1,i2) =
     &       entcell(i1,i2)%entcell%heat_capacity
        !call stop_model("not implemmented yet",255)
      endif

      if ( present(canopy_height) ) then
        canopy_height(i1,i2) =
     &       entcell(i1,i2)%entcell%h
      endif

      if ( present(fraction_of_vegetated_soil) ) then
        ! compute it here ?
        !call stop_model("not implemmented yet",255)
        if ( associated(entcell(i1,i2)%entcell) ) then
          fraction_of_vegetated_soil(i1,i2) =
     &         entcell(i1,i2)%entcell%fv
        else
          fraction_of_vegetated_soil(i1,i2) = 0.d0
        endif
      endif

      if ( present(C_labile) )
     &     C_labile(i1,i2) =
     &     entcell(i1,i2)%entcell%C_lab

      if ( present(R_auto) )
     &     R_auto(i1,i2) =
     &     entcell(i1,i2)%entcell%R_auto

      if ( present(soilresp) )
     &     soilresp(i1,i2) =
     &     entcell(i1,i2)%entcell%Soil_resp

      if ( present(beta_soil_layers) ) then
        do n=1,N_DEPTH
          beta_soil_layers(n,i1,i2) = 
     &         entcell(i1,i2)%entcell%betadl(n)
        enddo
      endif

      if ( present(albedo) ) then
        do n=1,N_BANDS
          albedo(n,i1,i2) =
     &         entcell(i1,i2)%entcell%albedo(n)
        enddo
      endif

      if ( present(vegetation_fractions) ) then
        call entcell_extract_pfts(entcell(i1,i2)%entcell,
     &       vegetation_fractions(:,i1,i2))
      endif

      if ( present(soilcpools) ) then
        do n=1,N_CASA_LAYERS
         do p=1,PTRACE
          do ii=1,NPOOLS
            soilcpools(p,ii,n,i1,i2) = 
     &      entcell(i1,i2)%entcell%Tpool(p,ii,n)
          end do
         end do
        enddo
      endif

      if ( present(leaf_area_index) )
     &     leaf_area_index(i1,i2) = 
     &     entcell(i1,i2)%entcell%LAI

      if ( present(C_total) )
     &     C_total(i1,i2) = 
     &     entcell(i1,i2)%entcell%C_total

      if ( present(C_entcell) ) then
        if ( associated(entcell(i1,i2)%entcell) ) then
          C_entcell(i1,i2) = 
     &     entcell_carbon( entcell(i1,i2)%entcell )
        else
	  C_entcell(i1,i2) = 0.d0
	endif
      endif 

      
      enddo
      enddo

      end subroutine ent_get_exports_r8_2




      subroutine ent_cell_print_r8_0(iu, entcell)
      integer, intent(in) :: iu
      type(entcelltype_public),intent(in):: entcell
      
      

      
      

      
        if ( associated(entcell%entcell) ) then
          call entcell_print( iu, entcell%entcell )
        else
          write( iu, *) "ent_cell_print: Empty entcell"
        endif
      

      end subroutine ent_cell_print_r8_0

      subroutine ent_cell_print_r8_1(iu, entcell)
      integer, intent(in) :: iu
      type(entcelltype_public),intent(in):: entcell(:)
      integer i1
      integer dims(2,1)

      dims(1,:) = lbound(entcell)
      dims(2,:) = ubound(entcell)

      
      do i1=dims(1,1),dims(2,1)
        if ( associated(entcell(i1)%entcell) ) then
          call entcell_print( iu, entcell(i1)%entcell )
        else
          write( iu, *) "ent_cell_print: Empty entcell"
        endif
      
      enddo

      end subroutine ent_cell_print_r8_1

      subroutine ent_cell_print_r8_2(iu, entcell)
      integer, intent(in) :: iu
      type(entcelltype_public),intent(in):: entcell(:,:)
      integer i1,i2
      integer dims(2,2)

      dims(1,:) = lbound(entcell)
      dims(2,:) = ubound(entcell)

      
      do i1=dims(1,1),dims(2,1)
      do i2=dims(1,2),dims(2,2)
        if ( associated(entcell(i1,i2)%entcell) ) then
          call entcell_print( iu, entcell(i1,i2)%entcell )
        else
          write( iu, *) "ent_cell_print: Empty entcell"
        endif
      
      enddo
      enddo

      end subroutine ent_cell_print_r8_2


      end module ent_mod


