SCMSGPCONT.R GISS Model E      awolf 08/2009   

SCM: RUN GISS Model E as SCM  using one latitude band                   
scm run using SGP Continuous Forcing Data from Jan 1999 - Dec 2001  
modelE1 (3.0) 2x2.5 hor. grid with 40 lyrs, top at .1 mb (+ 3 rad.lyrs)     ?
atmospheric composition from year 1979
ocean data: prescribed, 1975-1984 climatology
uses turbulence scheme (no dry conv), simple strat.drag (no grav.wave drag) ?
time steps: physics 30 min.; radiation 30 min.
filters: U,V in E-W direction (after every dynamics time step)              ?
         sea level pressure (after every physics time step)                 ?

Preprocessor Options
!#define TRACERS_ON                  ! include tracers code
#define SCM                          ! run as Single Column Model
#define NEW_IO
End Preprocessor Options

Object modules: (in order of decreasing priority)
#include "latlon_source_files"
#include "static_ocn_source_files"

ATM_COM
Atm144x90                         ! horiz/vert resolution, 2x2.5
AtmL40                             ! top at 0.1mb, 40 layers
MODEL_COM                           ! model variables and geometry
IO_DRV                              ! new i/o
TRIDIAG                             ! tridiagonal matrix solver
MODELE                              ! Main and model overhead
                                    ! parameter database
ALLOC_DRV                           ! domain decomposition, allocate 
                                    ! global distributed arrays
ATM_DRV                             ! driver for atmosphere-grid components
OCN_DRV                             ! driver for ocean-grid components
ATMDYN_COM ATMDYN_SCM MOMEN2ND  ! replace atmospheric dynamics with SCM routines
ATMDYN_SCM_EXT ATM_UTILS
SCM_COM SCMDATA_SGPCONT             ! routines for reading and processing SCM forcings and ICs
QUS_COM QUSDEF QUS_DRV              ! advection of tracers
TQUS_DRV                            ! advection of Q
CLOUDS2 CLOUDS2_DRV CLOUDS_COM      ! clouds modules
SURFACE SURFACE_LANDICE  FLUXES                     ! surface calculation and fluxes
GHY_COM GHY_DRV GHY GHY_H           ! land surface and soils and use ARM surface forcings     
VEG_DRV VEG_COM VEGETATION          ! vegetation
PBL_COM PBL_DRV PBL                 ! atmospheric pbl
ATURB                               ! ATURB - turbulence in whole atmosphere
LAKES_COM LAKES                     ! lake modules
SEAICE SEAICE_DRV                   ! seaice modules
LANDICE LANDICE_COM LANDICE_DRV                 ! land ice modules
ICEDYN_DUM                          ! ice dynamics modules
SNOW_DRV SNOW                       ! snow model
RAD_COM RAD_DRV RADIATION           ! radiation modules
RAD_UTILS ALBEDO READ_AERO          ! radiation and albedo
DIAG_COM DEFACC DIAG                ! diagnostics (diag, diag_prt dummies in scm_diag) 
DIAG_RES_F                          ! diagnostics (resolution dependent)
SCM_DIAG_COM SCM_DIAG               ! SCM diagnostics
      FFT144                        ! utilities

Components:
#include "E4_components_nc"    /* without "Ent" */

Data input files:
#include "IC_144x90_input_files"
#include "static_ocn_2000_144x90_input_files"
#include "land144x90_input_files"

REG=REG2X2.5          ! special regions-diag
RVR=RD_modelE_Fa.nc             ! river direction file
NAMERVR=RD_modelE_Fa.names.txt  ! named river outlets

#include "rad_input_files"
#include "TAero2003_input_files"
#include "rad_144x90_input_files"

MSU_wts=MSU.RSS.weights.data
SCMSRF=scm_sgpcont_0001_surface.dat
SCMLAY=scm_sgpcont_0001_layer.dat

Label and Namelist:
SCMSGPCONT (ModelE 2x2.5, 40 lyrs, 1979 atm/ocn;
up to 60 (or 52) columns here to describe your run)?<--col 53  to  72-->to 80-->
DTFIX=180.
&&PARAMETERS
! Target Coordinates for SCM
I_TARG=34        !Southern Great Plains 
J_TARG=64

#include "static_ocn_params"
#include "sdragF40_params"

PTLISO=15.  ! press(mb) above which rad. assumes isothermal layers

xCDpbl=1.
cond_scheme=2    ! more elaborate conduction scheme (GHY, Nancy Kiang)

 
U00a=.74    ! above 850mb w/o MC region; tune this first to get 30-35% high clouds
U00b=2.00   ! below 850mb and MC regions; then tune this to get rad.balance
! U00a,U00b replace the U00 parameters below - U00ice/U00wtrX are kept only for the _E1 version
U00ice=.57      ! tune this first to get: glob. ann. mean plan.alb=30%   (U00ice up=>albedo down)
U00wtrX=1.46    ! this to get: glob. ann. mean net heat at surf. = 0   (U00wtrX+.01=>NetHtSrf+.7)

H2ObyCH4=1.     ! activates strat.H2O generated by CH4
KSIALB=0        ! 6-band albedo (Hansen) (=1 A.Lacis orig. 6-band alb)
KSOLAR=2

#include "atmCompos_1850_params"
madaer=3

DTsrc=1800.     ! cannot be changed after a run has been started
DT=225.
! parameters that control the Shapiro filter
DT_XUfilter=225. ! Shapiro filter on U in E-W direction; usually same as DT (below)
DT_XVfilter=225. ! Shapiro filter on V in E-W direction; usually same as DT (below)
DT_YVfilter=0.   ! Shapiro filter on V in N-S direction
DT_YUfilter=0.   ! Shapiro filter on U in N-S direction

NIsurf=1        ! increase as layer 1 gets thinner
NRAD=1          ! Radiation called every dynamics time step

#include "diag_params"

Ndisk=480
Nssw=2   ! until diurnal diags are fixed, Nssw has to be even
&&END_PARAMETERS

 &INPUTZ
 YEARI=1949,MONTHI=12,DATEI=1,HOURI=0, ! pick IYEAR1=YEARI (default) or < YEARI
 YEARE=1949,MONTHE=12,DATEE=2,HOURE=0,     KDIAG=12*0,9,
 ISTART=2,IRANDI=0, YEARE=1949,MONTHE=12,DATEE=1,HOURE=1,
/

