SCMPnotEarth.R GISS Model E      M. Kelley 10/2013
                                     A. Wolf 08/2018

run with lat=0.0 lon=-145.0
SCM run based on P211eoZoht100_X001_O30.R from Michael Way

    socrates radiation and q-flux=0 ocean
    free-running using GCM inputs to initialize, then run with no dynamics,
    GCM surface forcings and no outside forcings 
    4x5 hor. grid, 40 layers 

Initial framework for truly single-column mode for Model E.

P211eoZoht100_X001_O30: P4SqM40 with 65m q-flux=0 ocean
P211eoZoht100_X001_O30: modelE as frozen in July 2009 without gravity wave drag
modelE 4x5 hor. grid with 40 lyrs, top at .1 mb (+ 3 rad.lyrs)
atmospheric composition from year 1850
uses turbulence scheme, simple strat.drag (not grav.wave drag)
time steps: dynamics 7.5 min leap frog; physics 30 min.; radiation 2.5 hrs
filters: U,V in E-W and N-S direction (after every physics time step)
         U,V in E-W direction near poles (after every dynamics time step)
         sea level pressure (after every physics time step)
radiation: planet (SOCRATES)

This is a functioning rundeck, not a template (excepting the lines
containing /path/to/user/directory/extractions - see notes below)

SCM-irrelevant codes and input files are excluded.
Template #includes should be refactored so that this exclusion happens automatically.

SCM case: PnotEarth based on P211eoZoht100_X001_O30 
For other cases, change one or more of the following as necessary:
(1) SCMDATA_XXXXXX case-specific code (until this aspect is generalized)
 (1*) also check SCM_COM.f for setup of flags for run with  SCM_SURFACE_FLAG=0 for Free-Running
(2) no SCM-specific forcing files
(3) lon_targ, lat_targ, and files extracted from gridded data at lon_targ, lat_targ
    See notes in the input files section on a pre-scripted extraction procedure etc.
    nominal_area may also be changed.

Preprocessor Options
#define SCM
#define USE_ENT
#define NEW_IO
#define PLANET_PARAMS notEarth
#define USE_PLANET_RAD
#define GISS_RAD_OFF
End Preprocessor Options

Object modules: (in order of decreasing priority)

AtmL40p  
AtmRes

SCM_COM
SCM_DIAG_PL
SCMDATA_FR 
ATMDYN_SCM
ATMDYN_SCM_EXT
SCM_DIAG_COM

CLOUDS_COM CLOUDS2 CLOUDS2_DRV

SURFACE
PBL_COM PBL_DRV PBL 
ATURB_E1

LANDICE LANDICE_COM SURFACE_LANDICE LANDICE_DRV

GHY_COM GHY_DRV

VEG_DRV
! VEG_COM VEGETATION 
ENT_DRV ENT_COM ! + Ent

LAKES_COM LAKES

OCN_DRV OCEAN OCNML

SEAICE SEAICE_DRV ICEDYN_DUM
Zenith

RAD_COM RADIATION RAD_DRV
COSZ_2D RAD_UTILS ALBEDO READ_AERO ocalbedo

planet_rad planet_alb lw_control sw_control ! planet radiation source files

DIAG_COM DIAG DEFACC QUICKPRT

ATM_DRV ATMDYN_COM ATM_UTILS ATM_COM

MODEL_COM
IO_DRV
MODELE
MODELE_DRV

QUS_COM QUSDEF

FLUXES

STRAT_DUM

Components:
shared MPI_Support solvers giss_LSM 
dd2d
socrates
Ent

Component Options:
OPTS_Ent = ONLINE=YES PS_MODEL=FBB
OPTS_giss_LSM = USE_ENT=YES

Data input files:

! The set of forcings for a particular SCM test case typically does not include
! all of the data required to run Model E.  Each line below of the form
!   SHORTNAME=/path/to/user/directory/extractions/filename.nc
! corresponds to a location-dependent input dataset for which one of the following
! two options must be chosen.  The second option is provided for convenience.
! (1) Replace /path/to/user/directory/extractions/filename.nc with the
!     path to a single-column file that has already been created somehow.
!     Note that the GCM file-reading infrastructure considers single-column
!     files to be on a horizontal grid of size 1, and therefore the
!     two horizontal dimensions must be retained in netcdf variables
!     (which must have the netcdf names that model E expects).
!     For any files previously extracted from global data via option (2),
!     make sure that the path does not contain substring "/extractions/"
!     if option (2) will be used create other files.
! (2) Use exec/extract_scm.sh to sample gridded files at location
!     lon_targ, lat_targ.
!     Firstly,
!       replace /path/to/user/directory with a real path, preferably which
!        (a) contains a string denoting the SCM location/case being run
!        (b) is unlikely to be chosen by any other users on the system
!       Habits (a) and (b) will prevent clutter and accidental overwrites.
!       Note that
!        (a) substring "/extractions/" must be retained in each path
!        (b) the rundeck paths indicate the resulting single-column files
!            to be read by the model.  GCMSEARCHPATH (from your modelErc)
!            is the location of the gridded file from which to extract the column
!        (c) There is no requirement that all files from which data are extracted are
!            on the same grid - dimension and coordinate information is scanned per-file.
!        (d) As currently programmed (10/2013), extract_scm.sh does require that
!            each file possesses 1D coordinate variables named lon(lon) and lat(lat).
!            Extraction from arbitrary grids (cubed-sphere etc.) will soon be enabled.
!        (e) NCO must be installed on your system and in your $PATH.
!     Secondly, execute
!        extract_scm.sh THISRUNDECK.R


! Topography, area fractions of surface types
TOPO=/path/to/user/directory/extractions/Z72X46N_gas.1_nocasp_btub005.nc

! Atm. initial conditions (temperature, wind, humidity, surface pressure)
! on the model's vertical grid and consistent with the
! orography from TOPO.  While some SCM modes
! of operation may subsequently overwrite the values from
! this file, the model has not yet been programmed to
! skip reading this file if it is absent.
AIC=/path/to/user/directory/extractions/AIC.RES_M20A.D771201_40L.nc

! Aerosols and O3 are deactivated by default in planet rundecks ***
! Optional: if absent, dust is set to zero
!DUSTaer=/path/to/user/directory/extractions/dust_mass_CakmurMillerJGR06_76x46x20x7x12.nc
!BC_dep=/path/to/user/directory/extractions/BC.Dry+Wet.depositions.ann.nc

! Optional: if absent and MADAER flag not set, aerosols are zero.
! If these files are omitted, rundeck parameters od_cdncx and cc_cdncx
! must not be set (or if set, set to zero.)
! Currently, these files must be used as a group (will change in future).
!TAero_SUL=/path/to/user/directory/extractions/SUL_Koch2008_kg_m2_72x46x20_1890-2000h.nc
!TAero_SSA=/path/to/user/directory/extractions/SSA_Koch2008_kg_m2_72x46x20h.nc
!TAero_NIT=/path/to/user/directory/extractions/NIT_Bauer2008_kg_m2_72x46x20_1890-2000h.nc
!TAero_OCA=/path/to/user/directory/extractions/OCA_Koch2008_kg_m2_72x46x20_1890-2000h.nc
!TAero_BCA=/path/to/user/directory/extractions/BCA_Koch2008_kg_m2_72x46x20_1890-2000h.nc
!TAero_BCB=/path/to/user/directory/extractions/BCB_Koch2008_kg_m2_72x46x20_1890-2000h.nc
! Optional: if absent, ozone is set to zero.
! Zero stratospheric ozone is usually a bad idea though.
!O3file=/path/to/user/directory/extractions/o3_2005_shindelltrop_72x46x49_1850-1997.nc

! These ocean files are only needed if the TOPO file for the
! SCM case contains a nonzero ocean fraction.  Certain SCM
! modes of operation may also prescribe ocean surface conditions
! via mechanisms other than these files. 

! For q-flux ocean, set KOCEAN=1, ISTART=8
OHT=/path/to/user/directory/extractions/zero_OHT_4x5_100m.nc
OCNML=/path/to/user/directory/extractions/zero_OCNML_4x5_100m.nc 


! These land-surface files are only needed if the TOPO file for
! the SCM case contains a nonzero land fraction.  But note
! that the GIC contains initial conditions for surface types other
! than the land surface and that the SOILIC method is an optional
! replacement for the land-surface GIC.
VEG=/path/to/user/directory/extractions/V72X46.1.cor2_no_cropsYANG.ext.nc !albedo=0.2 no veg
!soil_textures=/path/to/user/directory/extractions/soil_textures_top30cm
SOIL=/path/to/user/directory/extractions/S4X50093YANG.ext.nc  ! 50/50 clay/sand mix
SOILCARB_global=/path/to/user/directory/extractions/soilcarb_top30cm_4x5.nc
CDN=/path/to/user/directory/extractions/CD4X500S.ext.nc               ! surf.drag coefficient
TOP_INDEX=/path/to/user/directory/extractions/top_index_72x46_a.ij.ext.nc 



! Optional land-surface file which prescribes soil initial
! conditions in intuitive intensive units (temperature,
! relative wetness, snow depth) rather than the extensive
! units (total heat and water per layer) of the arrays in
! the file GIC.
!SOILIC=/path/to/SOILIC.nc

! Optional file to specify a "background" roughness
! length for the land surface that is not tied to
! the scale-dependent topographic standard deviation in
! TOP_INDEX as per the procedure developed for 8x10 Model II.
! Note that the actual roughness length for the
! land surface is taken as the maximum of the vegetation-derived
! value and the value from either ROUGHL or TOP_INDEX.
!ROUGHL=/path/to/ROUGHL.nc

! Initial conditions for surface components from an arbitrary restart file
GIC=/path/to/user/directory/extractions/GIC.E046D3M20A.1DEC1955.ext_1.rev.nc

! All input files below this line are location-independent.

RADN1=sgpgxg.table8
RADN3=miescatpar.abcdv2
RH_QG_Mie=oct2003.relhum.nr.Q633G633.table
!RADN7=STRATAER.VOL.SATO.1850-1999.Apr02_hdr
!RADN8=cloud.epsilon4.72x46


! optional files for optional diagnostics
!ISCCP=ISCCP.tautables
GHG=GHG.MWAY201412B.txt
MSU_wts=MSU.RSS.weights.data

Label and Namelist:
SCMPnotEarth (ModelE1 4x5,40 lyrs,1850 atm/ocn plan1 socrad q-flux ocn (4x5,Single Column Model)

&&PARAMETERS

! for SCM
! lon_targ and lat_targ only affect the solar zenith angle and
! corolis parameter (the latter is used in PBL parameterizations).
!  
lon_targ= -145.0
lat_targ= 0.0  
! nominal gridbox area (m2) from a 72x46 lon-lat grid 
nominal_area=247085409323.52 
GLMELT_ON=0   ! turn off GLMELT in run deck for runs that run more that a year

!initial_psurf_from_topo=1 ! Use if we have surface problems
planetName='notEarth'
MAXCTOP=1.
quantizeYearLength='False'
eccentricity=0.
obliquity=0.
minGroundTemperature=-250.0d0
maxGroundTemperature=300.0d0
! parameters set for choice of ocean model:
KOCEAN=1        ! ocn is computed
Kvflxo=0        ! usually set to 1 only during a prescr.ocn run by editing "I"
ocn_cycl=1      ! =0 if ocean varies from year to year

variable_lk=1 ! No dynamic lakes

wsn_max=2.


xCDpbl=1.
!cond_scheme=2    ! more elaborate conduction scheme (GHY, Nancy Kiang)

! Input files for planet radiation (SOCRATES)
solar_spec='sun'
spectral_file_lw='sp_lw_ga7/sp_lw_ga7_dsa'
spectral_file_sw='sp_sw_ga7/sp_sw_ga7_dsa'

CO2X=1.
O3X=0.
O2X=0.
NO2X=0.
N2OX=0.
CH4X=0.
CFC11X=0.
CFC12X=0.
N2CX=0.
XGHGX=0.
YGHGX=0.
SO2X=0.
H2OstratX=1.0

! cloud tuning parameters as of 2016/10/05 (D.S. Amundsen)
U00a=.50
U00b=0.50
wmu_multiplier=2.0

! Cloud inhomogeneity correction
KCLDEP=1    ! use a constant value for CLDEPS
EPSCON=0.12 ! use CLDEPS=0.12

! Stellar constant at 1 AU (default = 1360.67 W/m2)
planet_s0=1365.3 ! This is the value we used when we first started these runs 
! S0X has been removed and will have no effect on results


H2ObyCH4=0.     ! deactivates strat.H2O generated by CH4
l_uniform_ghg=1 ! turn off both horizontal (latitudinal) and vertical distributions of GHGs
KSIALB=0        ! 6-band albedo (Hansen) (=1 A.Lacis orig. 6-band alb)

! parameters that control the atmospheric/boundary conditions
! if set to 0, the current (day/) year is used: transient run
master_yr=1850
crops_yr=-1  ! if -1, crops in VEG-file is used
!s0_yr=1850
!s0_day=182
!ghg_yr=1850
!ghg_day=182
volc_yr=-1
!volc_day=182
!aero_yr=1850
od_cdncx=0.        ! don't include 1st indirect effect
cc_cdncx=0.        ! don't include 2nd indirect effect (used 0.0036)
!albsn_yr=1850
!dalbsnX=.024
!o3_yr=-1850
!aer_int_yr=1850    !select desired aerosol emissions year or 0 to use JYEAR
! atmCO2=368.6          !uatm for year 2000 - enable for CO2 tracer runs

! parameters that control the Shapiro filter
DT_XUfilter=450. ! Shapiro filter on U in E-W direction; usually same as DT (below)
DT_XVfilter=450. ! Shapiro filter on V in E-W direction; usually same as DT (below)
DT_YVfilter=0.   ! Shapiro filter on V in N-S direction
DT_YUfilter=0.   ! Shapiro filter on U in N-S direction

DTsrc=1800.     ! Atm. physics timestep.
NIsurf=1        ! Number of surface physics timesteps per atm. physics timestep.
NRAD=1


! parameters affecting diagn. output
aer_rad_forc=0   ! if set =1, radiation is called numerous times - slow !!
cloud_rad_forc=1 ! calls radiation twice; use =0 to save cpu time
isccp_diags=0    ! use =0 to save cpu time, but you lose some key diagnostics
nda5d=13         ! use =1 to get more accurate energy cons. diag (increases CPU time)
nda5s=13         ! use =1 to get more accurate energy cons. diag (increases CPU time)
ndaa=13
nda5k=13
nda4=48          ! to get daily energy history use nda4=24*3600/DTsrc

! KCOPY=1: save acc and alternating checkpoint files only.
! KCOPY=2: save end-of-month rsf also (probably not useful for SCM).
KCOPY=1

! save alternating checkpoint files every Ndisk timesteps
! (checkpoint also saved when model reaches end time).
! Useful for perusing instantaneous states or checking
! checking whether model states are identical after coding
! rearrangements.
Ndisk=1440
mincolmass=1000.
maxcolmass=20000000000.
rtau=320000.,270000.,220000.,170000.,120000.,70000.


! restart state is saveable every nssw timesteps.
Nssw=2

! SCM-useful GCM-native subdaily diagnostics system not yet imported to master branch
SUBDD=' '        ! no sub-daily frequency diags
NSUBDD=0         ! saving sub-daily diags every NSUBDD-th physics time step (1/2 hr)
&&END_PARAMETERS

 &INPUTZ
 YEARI=0001,MONTHI=1,DATEI=1,HOURI=0, ! pick IYEAR1=YEARI (default) or < YEARI
 YEARE=0401,MONTHE=01,DATEE=1,HOURE=0,     KDIAG=13*0,
 ISTART=2,IRANDI=0, YEARE=0011,MONTHE=01,DATEE=01,HOURE=0,
/
