EM20.R GISS Model E Tom Clune 02/28/2011

EM20:  This is a major update to the old E1M20 rundeck to correspond to AR5 defaults.


Preprocessor Options
#define USE_ENT
#define NEW_IO
End Preprocessor Options

Object modules:
     ! resolution-specific source codes
Atm72x46                         ! horizontal resolution is 72x46 -> 4x5deg
AtmL20 STRAT_DUM                ! vertical resolution is 20 layers -> 0.1mb
DIAG_RES_M            
FFT72                              ! Fast Fourier Transform

IO_DRV                             ! new i/o

     ! GISS dynamics w/o gravity wave drag
ATMDYN MOMEN2ND                     ! atmospheric dynamics
QUS_DRV QUS3D                       ! advection of Q/tracers

#include "latlon_source_files"
#include "modelE4_source_files"
#include "static_ocn_source_files"


Components:
#include "E4_components_nc"    /* without "Ent" */
Ent

Component Options:
OPTS_Ent = ONLINE=YES PS_MODEL=FBB    /* needed for "Ent" only */
OPTS_giss_LSM = USE_ENT=YES           /* needed for "Ent" only */

Data input files:
#include "IC_72x46_input_files"
#include "static_ocn_1880_72x46_input_files"

RVR=RD_modelE_M.nc                ! river direction file
NAMERVR=RD_modelE_M.names.txt     ! named river outlets

#include "land72x46_input_files"
#include "rad_input_files"
#include "rad_72x46_input_files"

MSU_wts=MSU.RSS.weights.data      ! MSU-diag
REG=REG4X5                      ! special regions-diag

Label and Namelist:  (next 2 lines)
EM20 (ModelE1 4x5, 20 lyrs, 1850 atm/ocn)

&&PARAMETERS
#include "static_ocn_params"
#include "sdragM20_params"
!#include "gwdragM20_params"

xCDpbl=1.
cond_scheme=2   ! newer conductance scheme (N. Kiang) ! not used with Ent

! Increasing U00a decreases the high cloud cover; increasing U00b decreases net rad at TOA
U00a=0.54      ! above 850mb w/o MC region; tune this first to get 30-35% high clouds
U00b=1.00      ! below 850mb and MC regions; then tune this to get rad.balance

WMUI_multiplier = 2.

PTLISO=15.       ! press(mb) above which rad. assumes isothermal layers
H2ObyCH4=1.      ! activates strat.H2O generated by CH4
KSIALB=0         ! 6-band albedo (Hansen) (=1 A.Lacis orig. 6-band alb)
KSOLAR=2         ! 2: use long annual mean file ; 1: use short monthly file

#include "atmCompos_1850_params"
madaer=3         ! 3: updated aerosols          ; 1: default sulfates/aerosols
aer_rad_forc=0
cloud_rad_forc=1

DTsrc=1800.      ! cannot be changed after a run has been started
DT=225.
! parameters that control the Shapiro filter
DT_XUfilter=225. ! Shapiro filter on U in E-W direction; usually same as DT
DT_XVfilter=225. ! Shapiro filter on V in E-W direction; usually same as DT
DT_YVfilter=0.   ! Shapiro filter on V in N-S direction
DT_YUfilter=0.   ! Shapiro filter on U in N-S direction

NIsurf=2         ! (surf.interaction NIsurf times per physics time step)
NRAD=5           ! radiation (every NRAD'th physics time step)
#include "diag_params"

Nssw=2           ! until diurnal diags are fixed, Nssw has to be even
Ndisk=480
&&END_PARAMETERS

 &INPUTZ
 YEARI=1949,MONTHI=12,DATEI=1,HOURI=0, ! pick IYEAR1=YEARI (default) or < YEARI
 YEARE=1949,MONTHE=12,DATEE=2,HOURE=0,     KDIAG=12*0,9,
 ISTART=2,IRANDI=0, YEARE=1949,MONTHE=12,DATEE=1,HOURE=1,
/
