c
c     save diagnostics for run of MODELE SCM
c      SCM_DIAG_PL.f
ccccc
ccccc
ccc    Note: Most of this is not needed for planetary run for PLANET_1.0 version of model
ccc     This is the old version of how we saved SCM diagnostics before they were moved to 
ccc     the sub-daily diagnostics
ccc     The diagnostics here can be written for each time step, but for longer runs this file gets
ccc     very large.  For monthly mean data it can be obtained from the acc files just as you would
ccc     for the GCM runs.  If you need time step data it can be added here quickly.  
ccc     most of what's here is commented out.   IT produces a binary file call scm.output 
ccc                                            and a text file scm.prt


      SUBROUTINE  SCM_DIAG  


      USE RESOLUTION, only: LM
      USE ATM_COM,    only: p,u,v,t,q,qcl,qci,gz,pk,PMID,PEDN
      USE MODEL_COM , only: dtsrc
      USE DYNAMICS,   only: sige,sig
      USE CLOUDS_COM, only: SVLHX,SVLAT,RHSAV,CLDSAV,tauss,taumc,
     &                cldss,cldmc,csizmc,csizss,ncol,LLOW,LMID,LHI
      use DIAG_COM, only : npres,ntau,isccp_press,isccp_tau
      USE SCMCOM
      USE SCMDIAG
      USE RAD_COM, only : srhr,trhr,cfrac
      USE FLUXES, only : atmlnd, atmsrf
      USE CONSTANT, only : SHA,GRAV,kapa,tf,RGAS,lhe
      USE GEOM, only : axyp 
      USE FILEMANAGER, only : openunit,closeunit
      

      IMPLICIT NONE

ccccc documentation from RADCOM
C              LX=40          23-layer model 
C     If LX is changed, need to change data statements in 
C     BLOCK DATA RADPAR that initialize PLB and HLB
c     PARAMETER (LX=40,LMOX=12*(1998-1881),MO3X=12*(2050-1850+1) )
c     REAL*4 TROAER,VDBCSU,TDUST,EPLMHC,UVLEAN   ! ,FVEG11,FOLGIZ     
c     REAL*4 ATAU98,SIZE98,HTF498,O3CLIM         !  only for offline use
c     CHARACTER*80 ATITLE,VTITLE,DTITLE,TITLE
C
c     COMMON/RADCM1/V6ALB(11,4,7),TAUWC0,TAUIC0,EPSCON,RO3COL,FULGAS(13)
c    A             ,FRAYLE,FALGAE,FCLDTR,FCLDSR,PTLISO,TLGRAD,FGOLDH(13)
c    B             ,WETTRA,WETSRA,FSXAER(5),FTXAER(5),FZSRA(6),FEMTRA(6)
c    C             ,KWVCON,KEEPAL,KEEPRH,KEEP10,KCNORM,KCLDEP,ICE012,NV
c    D             ,MADVES,MRELAY,MOZONE,KO3LON,NO3COL,NORMS0,KSOLAR
c    E             ,KTREND,NTRACE,ITR(8),NL,NLP,MLAT46,MLON72,LASTVC
c    X             ,HLB(LX),RHL(LX),TRACER(LX,8),AERTAU(LX),ZOICE
c    X             ,S00WM2,RATLS0,S0,XXJDAY,JYEARR,JDAYR,ISPARE(98)
c    X             ,DMOICE,DMLICE,TRSLCR,TRDFSL,TRUFSL
C     INPUT DATA
c     COMMON/RADCM2/
c    F              PLB(LX),        TLB(LX),TLT(LX),TLM(LX),U0GAS(LX,12)
c    G             ,ULGAS(LX,12),SHL(LX)
c    H             ,TAUWC(LX),TAUIC(LX),SIZEWC(LX),SIZEIC(LX),CLDEPS(LX)
c    I          ,POCEAN,PEARTH,POICE,PLICE,AGESN(3),SNOWE,SNOWOI,SNOWLI
c    J             ,TGO,TGE,TGOI,TGLI,TSL,WMAG,WEARTH,      FSPARE(998)
c    K                              ,COSZ,PVT(11),BXA(153),SRBXAL(15,2)
c    L                              ,JLAT,ILON
C     OUTPUT DATA
c    M             ,TRDFLB(LX),TRUFLB(LX),TRNFLB(LX),TRFCRL(LX)
c    N             ,SRDFLB(LX),SRUFLB(LX),SRNFLB(LX),SRFHRL(LX),SRSLHR
c    O             ,SRIVIS,SROVIS,PLAVIS,SRINIR,SRONIR,PLANIR,SRXATM(4)
c    P             ,SRDVIS,SRUVIS,ALBVIS,SRDNIR,SRUNIR,ALBNIR,FSRNFG(4)
c    Q             ,SRTVIS,SRRVIS,SRAVIS,SRTNIR,SRRNIR,SRANIR,FTRUFG(4)
c    R             ,TRDFGW,TRUFGW,TRUFTW,BTEMPW,              DTRUFG(4)
c    S             ,TRSLTS,TRSLTG,TRSLWV,TRSLBS,TTRUFG,LBOTCL,LTOPCL
c    X             ,Z0(12)
c
c-------------------------------------------------------------------------------
C
C 
C             Record Layout  
C 
C             NSTEPSCM            Time Stamp - note --- add date/time stamp also    
C             P                   Column Pressure (mb)
C             T          (LM)     Temperature (K) 
C             Q          (LM)     Specific Humidity (Kg/Kg)
C             TSAVG               Ts  -  Surface Air T (K) 
C             GTEMP(1,4,itarg,jtarg) Tskin  -  Sking temperature (C)
C             CLCVSS     (LM)     Cloud Cover SS (by area) 
C             CLCVMC     (LM)     Cloud Cover MC 
C             CLTHCK     (LM)     Cloud Thickness 
C             SCMQCL     (LM)     Cloud Liquid Water Content (Kg/Kg) 
C             SCMQCI     (LM)     Cloud Ice Water Content (Kg/Kg)
C             SVLHXCOL   (LM)     Liquid/Ice Flag (SS) save Latent Heats (j/Kg) 
C             SVLATCOL   (LM)     Liquid/Ice Flag (MC) save Latent Heats (j/Kg)
C             CSIZE      (LM,2)   Particle Size (10**-06m)     1=mc,2=ss 
C             EFFRAD     (LM)     Effective Radius (10**-06m)
C             CUMFLXCOL  (LM)     Cumulus Mass Flux (kg/m**2 /s) 
C             DWNFLXCOL  (LM)     Downdraft Mass Flux (kg/m**2 /s)
C             CUMHET     (LM)     Cumulus Heating  (10**14 W)
C             CUMOST     (LM)     Cumulus Moistening (10**14 W)
C             SRDFLBTOP           INC SW on Top of Atmos (W/m**2) 
C             SRNFLBTOP           SW ABSORBTION BELOW P0 (W/m**2)
C             TRUFLBTOP           UPward LW at P0  (W/m**2)
C             SRDFLBBOT           SW INC on Z0  (W/m**2)
C             SRNFLBBOT           SW ABS on Z0  (W/m**2)
C             TRUFLBBOT           Upward LW at Z0  (W/m**2)
C             TRDFLBBOT           LW INC on Z0  (W/m**2)
C             PRCSS               Precip - Large Scale SS (mm/hour) 
C             PRCMC               Precip - Convective (mm/hour)
C             SCM_PBL_HGT         height of the top of the boundary layer (m)
C             EVPFLX              Evaporation Flux 
C             SHFLX               Sensible Heat Flux 
C             SOILMS              Soil Moisture 
C             SRFHRLCOL(1-LM)*COSZ1  SW Heating 
C             TRFCRLCOL (1-LM)    LW Heating 
C             TAUSSC     (LM)     Cloud Optical Thickness - SS 
C             TAUMCC     (LM)     Cloud Optical Thickness - MC 
C             SG_P       (LM)     Pressure at sigma layers (mb)
C             CLSAV(LM)           SCM cloud fraction SS (by volume)
C             CLDFLG(LM)          SCM Cloud flag from Radia-outcome of Rand(0,1)
C             DWNFLX(LM)          SCM downdraft cloud mass flux (kg/m**2 /s)
C             RHC(LM)             SCM Relative Humidity saved after Cloud 
c                                     routines (Qs(over water))
c             PRESAV(LM)        SCM Large Scale Precip by layer (kg/kg)
c             PREMC(LM)         SCM MSTCNV Precip by layer (kg/kg)
c             LHPSAV(LM)        SCM Phase of Precip for SS
c             LHPMC(LM)         SCM Phase of Precip for MC
C--- Added by J.W. starting ---C
c             ENTSCM(LM,2)        SCM Entrainment rate for 2 two plume types
c             ENTDEEP(LM,2)       SCM Entrainment rate for deep convection - 2 plumes
c             MPLUMESCM(LM,2)        SCM Mass flux for 2 two plume types
c             MPLUMEDEEP(LM,2)       SCM Mass flux for deep convection - 2 plumes
c             DETRAINDEEP(LM,2,LM)  SCM Detrained convective condensate for Deep conv
C--- Added by J.W. ending ---C
c             WCUSCM(LM,2)        SCM Cumulus updraft speed for 2 two plume types
c             WCUDEEP(LM,2)       SCM  Cumulus updraft speed for deep convection - 2 plumes
c             PRCCDEEP(LM,2,LM)   SCM Precipitating convective condensate for Deep conv
c             NPRCCDEEP(LM,2,LM)  SCM Non-Precipitating conv condensate for Deep conv
c             TPALL(LM,2,LM)      SCM Plume Temperature for Deep Conv
c             MCCOND(LM,2,LM)     SCM convective condensate for deep and shallow  
c             PRCCGRP(LM,2,LM)    SCM deep convective condensate graupel
c             PRCCICE(LM,2,LM)    SCM deep convective condensate ICE
c             SCM_LWP_MC          SCM MC liquid water path (kg/m2)
c             SCM_IWP_MC          SCM MC ice water path (kg/m2)
c             SCM_LWP_SS          SCM SS liquid water path (kg/m2)
c             SCM_IWP_SS          SCM SS ice water path (kg/m2)
c             SCM_WM_MC(LM)       SCM Cloud water for moist convective clouds  kg/kg
c             SRUFLBBOT           Short Wave radiation up at z0 (W/m2)
c             SRUFLBTOP           Short Wave radiation up at p0 (W/m2)
c             TRDFLBTOP           Long Wave radiation down at p0 (W/m2)
c             dTtot(LM)           dT(modelPT)/dt over time step (K/day)
c             dqtot(LM)           dq/dt over time step (kg/kg /day)
c             dTfrc(LM)           dT(modelPT)/dt over time step from FORCN (K/day)
c             dqfrc(LM)           dq/dt over time step from FORCN (kg/kg /day)
c             dTrad(LM)           dT/dti(modelPT) over time step from radiation (K/day)
c             dTHmc(LM)           dTH/dt over time step from mstcnv (K/day)
c             dqmc(LM)            dq/dt over time step from mstcnv (kg/kg/day)
c             dTHbl(LM)           dTH/dt over time step from boundary layer (srf flxs + aturb) (K/day)
c             dqbl(LM)            dq/dt over time step from boundary layer (srf flxs + aturb) (kg/kg/day)
c             dTHss(LM)           dTH/dt over time step from large scale clouds (K/day) 
c             dqss(LM)            dq/dt over time step from large scale clouds (kg/kg/day) 
c

c             isccp record layout 
c
c             isccp_sunlit        ISCCP   1-day 0-night
c             isccp_ctp           ISCCP   cloud top pressure
c             isccp_tauopt        ISCCP   optical thickness
c             isccp_lowcld        ISCCP   low cloud fraction
c             isccp_midcld        ISCCP   mid cloud fraction
c             isccp_highcld       ISCCP   high cloud fraction
c             isccp_fq(ntau,npres)ISCCP  fraction of model grid box
c                                     covered by each of the 49 ISCCP D level cloud 
c                                     types
c             isccp_totcldarea    ISCCP  fraction of model grid box
c                                     columns with cloud somewhere in them
c                                     (sum over all fqI)
c             isccp_boxtau(ncol)  ISCCP optical thickness in each column
c             isccp_boxptop(ncol) ISCCP cloud top pressure (mb) in each column
c            
C              
C--- Added by J.W. starting ---C
      real*8 GZPRT(LM)
C--- Added by J.W. ending ---C
      real*8 TPRT(LM),QPRT(LM),TSURF,TSKIN,SCMQCI(LM),SCMQCL(LM),
     &       QSURF,ZSURF,USURF,VSURF,PSURF,PE1,TE1
      real*8 TOTCLCV(LM),LOWCLCV,MIDCLCV,HICLCV,TCLDRAD
      real*8 NET_RAD_PLANET,NETHT_GRND
      real*8 TDIFF,QDIFF
      real*8 PCOL, SVLHXCOL(LM),SVLATCOL(LM)    
      real*8 CUMFLXCOL(LM),DWNFLXCOL(LM)
      real*8 pk1000
      real*8 tt,tr,tmc,tss,tbl,ZE,DZ(LM),HL(LM)
      real*8 earthyrs,sday,syr
      real*4 ts4,tcldrad4,nrp4 
      INTEGER L,LMIN,IC,IU    
      INTEGER IPLUM,IPL,IPLUMSV      
      INTEGER IDEBUG

      real*8 QSAT

 
      if(iu_scm_diag.lt.0) then ! startup
c         call openunit('scm.save.sige',iu,.true.,.false.)
c         WRITE(iu) SIGE
c         call closeunit(iu)
          call openunit('scm.output',iu_scm_diag,.true.,.false.)
      endif

      pk1000 = 1000.**kapa
      sday=86400.0d0
      syr=365.d0*sday
      PCOL = P(1,1)
      TSURF = atmsrf%TSAVG(1,1)
      PSURF = atmsrf%SRFP(1,1)
cc    TSKIN = atmlnd%GTEMP(1,1)
      QSURF = atmsrf%QSAVG(1,1)
c     USURF = atmsrf%usavg(1,1)
c     VSURF = atmsrf%vsavg(1,1)
ccc   SCM_PBL_HGT = atmsrf%dblavg(1,1)   ??????
c     SCM_PBL_HGT = 0.0
c     do L = 1,LM
c        TPRT(L) = T(1,1,L)*PK(L,1,1) 
c        QPRT(L) = Q(1,1,L)
c        SCMQCL(L) = QCL(1,1,L)
c        SCMQCI(L) = QCI(1,1,L)
c        SVLHXCOL(L) = SVLHX(L,1,1)
c        SVLATCOL(L) = SVLAT(L,1,1)
c        CLCVSS(L) = CLDSS(L,1,1)
c        CLCVMC(L) = CLDMC(L,1,1)
c        TOTCLCV(L)=CLCVSS(L)+CLCVMC(L)
c        CLSAV(L) = CLDSAV(L,1,1)   
c        TAUSSC(L) = TAUSS(L,1,1)
c        TAUMCC(L) = TAUMC(L,1,1)
c        GZPRT(L) = GZ(1,1,L)
c        SG_P(L) = PMID(L,1,1)
ccc Now use potential temp  in K/day and q still in kg/kg 
c        dTtot(L) = PK1000*dTtot(L)*sday/dtsrc
c        dqtot(L) = dqtot(L)*sday/dtsrc
c        dTfrc(L) = PK1000*dTfrc(L)*sday/dtsrc
c        dqfrc(L) = dqfrc(L)*sday/dtsrc
c        dTrad(L) = PK1000*dTrad(L)*sday/dtsrc
ccc here change to potential temperature (factor of 1000**kapa)
c        dTHmc(L) = PK1000*dTHmc(L)*sday/dtsrc
c        dqmc(L) = dqmc(L)*sday/dtsrc
c        dTHbl(L) = PK1000*dTHbl(L)*sday/dtsrc
c        dqbl(L) = dqbl(L)*sday/dtsrc
c        dTHss(L) = PK1000*dTHss(L)*sday/dtsrc
c        dqss(L) = dqss(L)*sday/dtsrc
c     enddo      


cccc   Saved for planetary run

      TCLDRAD = cfrac(1,1)*100.d0
      NET_RAD_PLANET=-(TRNFLBTOP)+SRNFLBTOP
      NETHT_GRND=atmsrf%e0(1,1)/dtsrc
      
      ts4 = TSURF 
      tcldrad4 = TCLDRAD
      nrp4 = NET_RAD_PLANET





c calculate SG_HGT and SG_RH
      do L=1,LM+1
         SGE_P(L)=PEDN(L,1,1)
      enddo
      PE1 = PEDN(1,1,1)
c     ZE = 0.d0
c     do L=1,LM
c        DZ(L) = ((SGE_P(L)-SGE_P(L+1))/SG_P(L))*((RGAS/GRAV)*TPRT(L))
c        SG_HGT(L) = ZE + DZ(L)/2.0
c        SG_RH(L) = QPRT(L)/QSAT(TPRT(L),LHE,SG_P(L))
c        ZE = ZE + DZ(L)
c     enddo

c     CUMFLXCOL = 0.d0
c     DWNFLXCOL = 0.d0
c     do LMIN = 1,LM
c        do IC = 1,2
c           do L=1,LM
c              CUMFLXCOL(L) = CUMFLXCOL(L) + CUMFLX(L,IC,LMIN)
c              DWNFLXCOL(L) = DWNFLXCOL(L) + DWNFLX(L,IC,LMIN)
c           enddo
c        enddo
c     enddo


c     do L=1,LM
C--- Added by J.W. starting ---C
c        ENTSCM(L,1) = 0.0
c        ENTSCM(L,2) = 0.0
c        MPLUMESCM(L,1) = 0.0
c        MPLUMESCM(L,2) = 0.0
C--- Added by J.W. ending ---C
c        WCUSCM(L,1) = 0.0
c        WCUSCM(L,2) = 0.0
c     enddo
c     do ic=1,2
c        IPLUM = 0
c        do LMIN = 1,LM
c           do L=1,LM
c              if (WCUALL(L,ic,LMIN).ne.0.0d0) then
c                  IPLUM = LMIN 
c                  go to 25
c              endif
c           enddo
c        enddo
25       continue
c        if (IPLUM.gt.0) then
c            do L=1,LM
c               WCUSCM(L,ic) = WCUALL(L,ic,IPLUM) 
C--- Added by J.W. starting ---C
c               MPLUMESCM(L,ic) = MPLUMEALL(L,ic,IPLUM)
c               ENTSCM(L,ic) = ENTALL(L,ic,IPLUM)
C--- Added by J.W. ending ---C
c            enddo
c        endif
c     enddo

C     before writing out diagnostics convert cumulus diagnostics
c     do L = 1,LM
c        CUMHET(L) = CUMHET(L)*10.E-13*SHA*AXYP(1,1)/(GRAV*DTSRC)
c        CUMOST(L) = CUMOST(L)*10.E-13*SHA*AXYP(1,1)/(GRAV*DTSRC)
c     enddo

c     WRITE(iu_scm_diag) NSTEPSCM,PCOL,SG_P,SG_HGT,TPRT,QPRT,
c    *     SG_RH,SVLHXCOL,SVLATCOL,SCMQCL,SCMQCI,CLCVSS,CLCVMC,
c    *     SG_U,SG_V,CSIZE,EFFRAD,CUMFLXCOL,DWNFLXCOL,TAUSSC,
c    *     TAUMCC,dTtot,dqtot,dTfrc,dqfrc,
c    *     dTrad,dTHmc,dqmc,dTHbl,dqbl,dTHss,dqss,dTradlw,dTradsw,
c    *     GZPRT,TSKIN,TSURF,QSURF,USURF,VSURF,EVPFLX,SHFLX,PRCSS,
c    *     PRCMC,SCM_PBL_HGT,SRDFLBTOP,SRNFLBTOP,TRUFLBTOP,
c    *     SRDFLBBOT,SRNFLBBOT,TRUFLBBOT,TRDFLBBOT,SRUFLBBOT,
c    *     SRUFLBTOP,TRDFLBTOP,TRNFLBBOT,CSSRNTOP,CSTRUTOP,CSSRNBOT,
c    *     CSTRNBOT,CSSRDBOT,SRFHRLCOL,TRFCRLCOL,
c    *     PLUME_MIN,PLUME_MAX,SCM_H,SCM_HSAT 
c    *            ,isccp_sunlit,isccp_ctp,
c    *           isccp_tauopt,isccp_lowcld,isccp_midcld,isccp_highcld,
c    *           isccp_fq,isccp_totcldarea,isccp_boxtau,isccp_boxptop


cccc saved for planetary run


      earthyrs = (NSTEPSCM*DTsrc)/syr 
c     WRITE(iu_scm_diag) earthyrs,
c    *     TSURF,PSURF,TCLDRAD,NET_RAD_PLANET
c     WRITE(iu_scm_diag) earthyrs,ts4,tcldrad4,nrp4

C 
c     if (NSTEPSCM.lt.100.or.MOD(NSTEPSCM,1000).eq.0) 
c    &     write(iu_scm_prt,100) NSTEPSCM,earthyrs,PSURF,TSURF,
c    &      NET_RAD_PLANET,SRNFLBTOP,TRNFLBTOP,NETHT_GRND,TCLDRAD,
c    &      SRDFLBTOP 
c100   format(1x,I10,f12.6,' Ps Ts ',2(f8.2),'  NRP SWN TWN  NHG ',
c    &      4(f10.2),'  TOTCL ',f8.2,'  SWDtoa ',f10.2)

c
c     IDEBUG = 0
c     if (MOD(NSTEPSCM,1000).eq.0 .or. NSTEPSCM.lt.20) then
c       do L=1,LM
c        write(iu_scm_prt,140) L,SG_P(L),TPRT(L),
c    +      QPRT(L)*1000.0,SCMQCL(L)*1000.,SCMQCI(L)*1000.,TOTCLCV(L),
c    &      CLCVSS(L)*100.,CLCVMC(L)*100.
c140     format(1x,i2,f8.2,' T ',f7.2,' Q',f7.3,' qcl qci ',2(f8.3),
c    &       ' totcldcv ',f8.5,' clcvss clcvms ',2(f10.5))
c       enddo 
c     endif 

      RETURN 

      END SUBROUTINE SCM_DIAG 
