# standard makefile to be use in each "component" subdir
.PHONY: FORCE


#get defaults from ~/.modelErc
HOMEDIR = $(wildcard ~)
MODELERC ?= $(HOMEDIR)/.modelErc
sinclude $(MODELERC)


# the name for main target:
THIS := $(shell basename `pwd`)
LIB  = lib$(THIS).a

ifeq ($(BUILD_OUT_OF_SOURCE),YES)
  ifneq ($(THIS),model)
    PATH_TO_COMPONENT = $(MODEL_E_ROOT)/model/$(THIS)
  else
    PATH_TO_COMPONENT = $(MODEL_E_ROOT)/model
  endif
  ifneq ($(SRC_DIRS),)
    VPATH += $(addprefix $(PATH_TO_COMPONENT)/, $(SRC_DIRS))
  else
    VPATH += $(PATH_TO_COMPONENT)
  endif
else
  VPATH += $(SRC_DIRS)
endif

#path to external components
VPATH += $(ABS_SRC_DIRS)

# directory for html documents
ifneq ($(THIS),model)
HTMLDOC_DIR_THIS = $(HTMLDOC_DIR)/COMPONENT___$(THIS)
else
HTMLDOC_DIR_THIS = $(HTMLDOC_DIR)
endif

#hack
DEPENDFILE = .depend

#hack to build archive on MAC
RANLIB_FLAGS = 
ifeq ($(shell uname),Darwin)
RANLIB_FLAGS = -c
endif

#default target:
default: $(LIB)

#hack to overwrite the list of sources from rundeck
ifdef OVERWRITE_FSRCS
FSRCS = $(OVERWRITE_FSRCS)
endif
ifdef OVERWRITE_F90SRCS
F90SRCS = $(OVERWRITE_F90SRCS)
endif

OBJS = $(FSRCS:.f=.o) $(CSRCS:.c=.o) $(F90SRCS:.F90=.o)
FSRCS_CPP = $(FSRCS:.f=.f.cpp)
F90SRCS_CPP = $(F90SRCS:.F90=.F90.cpp)

FFSRCS = $(FSRCS) $(F90SRCS)
FFSRCS_CPP = $(FSRCS_CPP) $(F90SRCS_CPP)


#rule for "ar" , should be moved to rules later
$(LIB): $(OBJS)
	-rm -f $(LIB)
	ar rcs $(LIB) $(OBJS)
	$(RANLIB) $(RANLIB_FLAGS) $(LIB)
	-cp -p $(MODS) $(MOD_DIR)
#	cp $(LIB) $(LIB_DIR)

#.INTERMEDIATE: $(FFSRCS_CPP) $(DEPENDFILE)_cpp $(DEPENDFILE)_f

$(DEPENDFILE): $(FFSRCS) $(CSRCS) .current_options $(RUN_H)
	@echo
	@echo '--------          Rebuilding Dependencies  in        ---------'
	@echo '--' `pwd`
	@echo '====> running CPP'
	-rm -f $(DEPENDFILE)_cpp
	for i in $(filter %.f %.F90,$^); do $(CPP) -M $(CPPFLAGS) $$i >> $(DEPENDFILE)_cpp; \
	$(CPP) $(CPPFLAGS) $$i > `basename $$i`.cpp; \
	done
	for i in $(filter %.c,$^); do $(filter-out -traditional,$(CPP)) -M $(CPPFLAGS) $$i >> $(DEPENDFILE)_cpp; \
	done
	@echo '====> running fmakedep'
	-rm -f $(DEPENDFILE)_tmp
	$(FMAKEDEP) $(CPPFLAGS) $(addprefix -I,$(VPATH)) -f $(DEPENDFILE)_tmp $(FFSRCS_CPP)
	$(SCRIPTS_DIR)/check_dep.pl $(DEPENDFILE)_tmp
	$(SCRIPTS_DIR)/pproc_dep.pl  $(DEPENDFILE)_tmp > $(DEPENDFILE)_f
	-rm -f $(DEPENDFILE)_tmp
	-rm -f  $(FFSRCS_CPP)
	echo "# dependencies generated by cpp:" > $(DEPENDFILE)
	cat $(DEPENDFILE)_cpp >> $(DEPENDFILE)
	cat $(DEPENDFILE)_f >> $(DEPENDFILE)
	-rm -f $(DEPENDFILE)_cpp $(DEPENDFILE)_f
	@echo '---------         done with dependencies             ---------'
	@echo


clean:
	-rm -f $(LIB) lib.a *.o *.mod *.smod .depend* .current_options rundeck_opts.h *.cpp

deplist:
	echo $(THIS)_dir: $(DEPENDS_ON:=_dir)
	-rm $(DEPENDFILE)

MODS = $(shell [ -s $(DEPENDFILE) ] && perl \
        -e 'while(<>){ push @a, /(\S+\.mod)\s*:/gi; } print join " ",@a;' \
        $(DEPENDFILE) )

depend: $(DEPENDFILE)

.current_options: FORCE
	@echo $(CURRENT_OPTIONS) > .current_options.tmp
	@if [ ! -f .current_options ] || \
	! cmp -s .current_options  .current_options.tmp ; then \
	mv -f .current_options.tmp .current_options; \
	else rm -f .current_options.tmp ; \
	fi

# create a list of all specified options, including the list
# of source files
define PROGRAM_opt_list
CURRENT_OPTIONS += $(1)=$($(1)),
endef

CURRENT_OPTIONS =
$(foreach v,$(SUPPORTED_OPTIONS) FFSRCS, \
  $(eval $(call PROGRAM_opt_list,$(v))))

ifeq ($(findstring $(MAKECMDGOALS),clean depend depend_all),)
sinclude $(DEPENDFILE)
endif


# html documantation
htmldoc: $(FFSRCS_CPP)
ifneq ($(FFSRCS),)
	[ -d $(HTMLDOC_DIR) ] || mkdir $(HTMLDOC_DIR)
	-mkdir $(HTMLDOC_DIR_THIS)
	$(SCRIPTS_DIR)/gcmdoc.pl -O $(HTMLDOC_DIR_THIS) -R $(RUN) -C $(THIS) -CPP .cpp $(FFSRCS)
	rm -f $(FFSRCS_CPP)
else
	@echo no .f files - will skip directory $(THIS)
endif

