NINT_oH_359x360x32.R GISS Model E  coupled version modelE + hycom ocean 359x360x32

N.Tausnev 03/23/2017
ocean H with various different horizontal/vertical resolutions activated.
This template should be considered temporary until the
new template system has been finalized.

Preprocessor Options
#define NEW_IO                   ! new I/O (netcdf) on
#define CHECK_OCEAN                  ! needed to compile aux/file CMPE002
#define TRACERS_AGE_OCEAN
#define ATM2x2h                      ! 2x2.5 40 layer atm
! #define HYCOM1degRefined           ! 1deg   refined hycom (387x360)
#define HYCOM1degUnrefined           ! 1deg unrefined hycom (359x360)
! #define HYCOM26layers              ! use 26 layers in hycom
#define HYCOM32layers                ! use 32 layers in hycom
#define EXPEL_COASTAL_ICEXS          ! Attempt decrease the coastal ice thicknes
End Preprocessor Options

Object modules:
     ! resolution-specific source codes
Atm144x90                           ! horizontal resolution is 144x90 -> 2x2.5deg
AtmL40                              ! vertical resolution is 40 layers -> 0.1mb
DIAG_RES_F                          ! diagnostics
FFT144                              ! Fast Fourier Transform

IO_DRV                              ! new i/o

     ! GISS dynamics with gravity wave drag
ATMDYN MOMEN2ND                     ! atmospheric dynamics
QUS_DRV QUS3D                       ! advection of Q/tracers
STRATDYN STRAT_DIAG                 ! stratospheric dynamics (incl. gw drag)

#include "latlon_source_files"
#include "modelE4_source_files"
#include "hycom_source_files"

Components:
#include "E4_components_nc"
Ent

Component Options:
OPTS_Ent = ONLINE=YES PS_MODEL=FBB PFT_MODEL=ENT
OPTS_dd2d = NC_IO=PNETCDF

Data input files:
#include "IC_144x90_input_files"
#include "dynamic_ocn_hycom_359x360x32_input_files_AR5"
TOPO=Z144X90N.h359x360_jan2017.nc              ! surface fractions and topography
ICEDYN_MASKFAC=iceflowmask_144x90.nc

RVR=RD_modelE_Fa.RVR_hycom_jan2017.nc  ! river direction file
NAMERVR=RD_Fb.names_hycom_jan2017.txt  ! named river outlets

#include "land144x90_input_files"
#include "rad_input_files"
#include "rad_144x90_input_files"

MSU_wts=MSU_SSU_RSS_weights.txt      ! MSU-diag
REG=REG2X2.5                      ! special regions-diag

Label and Namelist:  (next 2 lines)
NINT_oH2 (E4F40 + 1-deg ocean H with new coupler and space resolutions)

&&PARAMETERS

#include "dynamic_ocn_params"

#include "sdragF40_params"
#include "gwdragF40_params"

! cond_scheme=2   ! newer conductance scheme (N. Kiang) ! not used with Ent

! The following two lines are only used when aerosol/radiation interactions are off
FS8OPX=1.,1.,1.,1.,1.5,1.5,1.,1.
FT8OPX=1.,1.,1.,1.,1.,1.,1.,1.

! Increasing U00a decreases the high cloud cover; increasing U00b decreases net rad at TOA
U00a=0.64 ! above 850mb w/o MC region;  tune this first to get 30-35% high clouds
U00b=1.   ! below 850mb and MC regions; tune this last  to get rad.balance
WMUI_multiplier = 2.
use_vmp=1
radius_multiplier=1.1

PTLISO=15.       ! press(mb) above which rad. assumes isothermal layers
H2ObyCH4=1.      ! activates strat.H2O generated by CH4
KSOLAR=2         ! 2: use long annual mean file ; 1: use short monthly file

#include "atmCompos_1850_params"
madaer=3         ! 3: updated aerosols          ; 1: default sulfates/aerosols

DTsrc=1800.      ! cannot be changed after a run has been started
DT=225.
! parameters that control the Shapiro filter
DT_XUfilter=225. ! Shapiro filter on U in E-W direction; usually same as DT
DT_XVfilter=225. ! Shapiro filter on V in E-W direction; usually same as DT
DT_YVfilter=0.   ! Shapiro filter on V in N-S direction
DT_YUfilter=0.   ! Shapiro filter on U in N-S direction

NIsurf=2         ! (surf.interaction NIsurf times per physics time step)
NRAD=5           ! radiation (every NRAD'th physics time step)
#include "diag_params"

Nssw=48          ! until diurnal diags are fixed, Nssw has to be even
Ndisk=480

itest=-1         ! default is -1
jtest=-1         ! default is -1
iocnmx=2         ! default is 2
brntop=50.       ! default is 50.
brnbot=200.      ! default is 200.
diapyn=2.e-7     ! default is 2.e-7
diapyc=.2e-4     ! default is .2e-4
jerlv0=1         ! default is 1; 0 => read dataset
bolus_biharm_constant=0   ! bolus_biharm_constant=1 uses thkdff=0.05 or 0.10 m/s
bolus_laplc_constant=1    ! bolus_laplc_constant=1  uses thkdff=0.01 or 0.02 m/s
bolus_laplc_exponential=0 ! bolus_laplc_exponential=1 uses thkdff=0.03 m/s; thkdff_bkgd is hard-wired to 0.003m/s
thkdff=.01

&&END_PARAMETERS


 &INPUTZ
 YEARI=1900,MONTHI=01,DATEI=01,HOURI=00, ! pick IYEAR1=YEARI (default) or < YEARI
 YEARE=1949,MONTHE=01,DATEE=01,HOURE=00,     KDIAG=12*0,9,
 ISTART=2,IRANDI=0, YEARE=1900,MONTHE=01,DATEE=02,HOURE=00,
/
