E213F40oQ40.R     GISS Model E     atmosphere-ocean     2020/10/16

E213F40oQ40 = E213F40oQ40(from Larissa) + E2.1_branch
E213F40oQ40: E200F40oQ40 + updated aerosol/ozone input files based on E25TomaF40pi
E200F40oQ40: E199F40oQ40 + 5m maximum for lake ice (LAKE_ICE_MAX=5.) 
E199F40oQ40: E198F40oQ40 + no leads (OPNOCN=0.; SEAICE_E199.f); 
             AIC=1JAN3901.rsfE198F40oQ40.nc 
E198F40oQ40: E197F40oQ40 + alternative OCNMESO_DRV 
E197F40oQ40: E196F40oQ40 + alternative TOPO_OC 
E196F40oQ40: E193F40oQ32 + 40 vertical layers in ocean; 
             adjusted straits, salinity, tides 
E193F40oQ32: E190F40oQ32 + new aer.input data based on E08TomaF40pi
E190F40oQ32: GISS coupled model, based on E137F40pi

3/27/2017 updated to latest F40 atm (aerosol/ozone inputs etc.)

M. Kelley 08/12/2016 cloned E4F40 and added 1-degree
ocean R with various new mixing options activated.
This template should be considered temporary until the
new template system has been finalized.


Preprocessor Options
#define NEW_IO                  ! new I/O (netcdf) on
#define ATM_LAYERING L40        ! 40 layers, top at .1 mb
#define STDHYB                  ! standard hybrid vertical coordinate
#define IRRIGATION_ON
#define SWFIX_20151201
#define NEW_BCdalbsn
#define OCN_LAYERING L40_5008m
#define CHECK_OCEAN             ! needed to compile aux/file CMPE002
#define SIMPLE_MESODIFF
#define ODIFF_FIXES_2017
#define EXPEL_COASTAL_ICEXS
#define NEW_IO_SUBDD
#define CACHED_SUBDD
End Preprocessor Options


Object modules:
     ! resolution-specific source codes
Atm144x90                           ! horizontal resolution is 144x90 -> 2x2.5deg
AtmLayering                         ! vertical resolution
DIAG_RES_F                          ! diagnostics
FFT144                              ! Fast Fourier Transform
ORES_1Qx1 OFFT288E                  ! ocean horiz res 1.25x1deg
IO_DRV                              ! new i/o

     ! GISS dynamics with gravity wave drag
ATMDYN MOMEN2ND                     ! atmospheric dynamics
QUS_DRV QUS3D                       ! advection of Q/tracers
STRATDYN STRAT_DIAG                 ! stratospheric dynamics (incl. gw drag)

#include "latlon_source_files"
#include "modelE4_source_files"
#include "dynamic_ocn_source_files_CMIP6"
OCN_Int_LATLON                      ! atm-ocn regrid routines
SUBDD

Components:
#include "E4_components_nc"
Ent

Component Options:
OPTS_Ent = ONLINE=YES PS_MODEL=FBB PFT_MODEL=ENT
OPTS_dd2d = NC_IO=PNETCDF


Data input files:
    ! start from the restart file of an earlier run ...                 ISTART=9
AIC=1JAN7501.rsfE200F40oQ40.nc

    ! start from observed conditions AIC(,OIC), model ground data GIC   ISTART=2
!! AIC=NCARIC.144x90.D7712010_ext.nc ! AIC for automatic relayering to model vertical grid
!! GIC=GIC.144X90.DEC01.1.ext_1.nc   ! initial ground conditions
!! OIC=altocnbc288x180_20170717/tempsalt_dec1_288x180_phc3.0_ext.nc     ! Levitus ocean intial conditions

#include "dynamic_ocn_288x180_input_files_CMIP6_istart8or9"
TDISS=altocnbc288x180_20170717/TIDAL_e_v2_1QX1.HB.nc
TDISS_N=tdiss/Jayne2009_288x180.nc
POROS=altocnbc288x180_20170717/poros.nc

TOPO=Z2HX2fromZ1QX1N.BS1.nc         ! surface fractions and topography (1 cell Bering Strait)
ICEDYN_MASKFAC=iceflowmask_144x90.nc

RVR=RD_Fd.nc             ! river direction file
NAMERVR=RD_Fd.names.txt  ! named river outlets

#include "land144x90_input_files"

#include "rad_input_files"

#include "rad_144x90_input_files_CMIP6_E213"

MSU_wts=MSU_SSU_RSS_weights.txt      ! MSU-diag
REG=REG2X2.5                      ! special regions-diag


Label and Namelist:  (next 2 lines)
E213F40oQ40 (E200F40oQ32 + updated aerosol/ozone input files based on E25TomaF40pi)
E213F40oQ40 = E213F40oQ40(from Larissa) + E2.1_branch


&&PARAMETERS
#include "dynamic_ocn_params"
ocean_use_qus=1     ! Advection uses the quadratic upstream scheme
DTO=112.5
ocean_use_tdmix=1  ! tdmix scheme for meso mixing
ocean_use_gmscz=1  ! vertically variation of meso diffusivity, option 1
ocean_kvismult=2.  ! mult. factor for meso diffusivity
ocean_enhance_shallow_kmeso=1 ! stronger meso mixing in shallow water
ocean_use_tdiss=1  ! simple tidally induced diapycnal diffusivity

#include "sdragF40_params"

#include "gwdragF40_params"

! cond_scheme=2   ! newer conductance scheme (N. Kiang) ! not used with Ent

! No tau adjustment factors for aerosols
FS8OPX=1.,1.,1.,1.,1.5,1.5,1.,1.
FT8OPX=1.,1.,1.,1.,1.,1.,1.3,1.

! Increasing U00a decreases the high cloud cover; increasing U00b decreases net rad at TOA
U00a=0.655 ! above 850mb w/o MC region;  tune this first to get 30-35% high clouds
U00b=1.    ! below 850mb and MC regions; tune this last  to get rad.balance
WMUI_multiplier = 2.
use_vmp=1
radius_multiplier=1.1

PTLISO=0.        ! press(mb) above which rad. assumes isothermal layers
H2ObyCH4=1.      ! activates strat.H2O generated by CH4
KSOLAR=2         ! 2: use long annual mean file ; 1: use short monthly file

#include "atmCompos_1850_params"
madaer=3         ! 3: updated aerosols          ; 1: default sulfates/aerosols

DTsrc=1800.      ! cannot be changed after a run has been started
DT=225.
! parameters that control the Shapiro filter
DT_XUfilter=225. ! Shapiro filter on U in E-W direction; usually same as DT
DT_XVfilter=225. ! Shapiro filter on V in E-W direction; usually same as DT
DT_YVfilter=0.   ! Shapiro filter on V in N-S direction
DT_YUfilter=0.   ! Shapiro filter on U in N-S direction

NIsurf=2         ! (surf.interaction NIsurf times per physics time step)
NRAD=5           ! radiation (every NRAD'th physics time step)

#include "diag_params"

Nssw=2           ! until diurnal diags are fixed, Nssw has to be even
Ndisk=960
&&END_PARAMETERS

 &INPUTZ
 YEARI=7501,MONTHI=1,DATEI=1,HOURI=0, ! pick IYEAR1=YEARI (default) or < YEARI
 YEARE=7502,MONTHE=1,DATEE=1,HOURE=0,     KDIAG=12*0,9,
 ISTART=9,IRANDI=0, YEARE=7501,MONTHE=1,DATEE=1,HOURE=1,
/
