!------------------------------------------------------------------------------
Module SpecialFunctions_mod
!------------------------------------------------------------------------------
!@sum Module that contains methods to calculate special functions
!@auth SSSO ASTG
  implicit none
  private
  public besselI0

  integer, parameter :: DP = selected_real_kind(14)

!------------------------------------------------------------------------------
contains
!------------------------------------------------------------------------------

  ! Based upon Abromowitz and Stegun 9.8.1 and 9.8.2
  REAL(kind=DP) FUNCTION BesselI0(x)
!@sum Modified Bessel's function I0
    REAL(kind=DP), intent(in) :: x
    REAL(kind=DP) :: ax,y
    REAL(kind=DP), parameter :: p1=1.0d0, p2=3.5156229d0, p3=3.0899424d0, &
      p4=1.2067492d0, p5=0.2659732d0, p6=0.360768d-1, &
      p7=0.45813d-2
    REAL(kind=DP), parameter :: q1=0.39894228d0,q2=0.1328592d-1, &
      q3=0.225319d-2, q4=-0.157565d-2, q5=0.916281d-2, &
      q6=-0.2057706d-1, q7=0.2635537d-1, q8=-0.1647633d-1, &
      q9=0.392377d-2

    if (abs(x) < 3.75d0) then
      y = (x/3.75d0)**2.d0
      BesselI0 = (p1 + y*(p2 + y*(p3 + y*(p4 + y*(p5 + y*(p6 + y*p7))))))
    else
      ax = abs(x)
      y = 3.75d0/ax
      BesselI0 = (exp(ax)/sqrt(ax))*(q1 + y*(q2 + y*(q3 + y*(q4 &
        + y*(q5 + y*(q6 + y*(q7 + y*(q8 + y*q9))))))))
    end if

  END FUNCTION BesselI0

end Module SpecialFunctions_mod
