#include "rundeck_opts.h" 

!===============================================================================
module tracers_radon_com
!===============================================================================

implicit none

real*8, allocatable, dimension(:,:,:) :: rn_src

!===============================================================================
contains
!===============================================================================

!-------------------------------------------------------------------------------
subroutine alloc_radon_sources(grid)
!-------------------------------------------------------------------------------
use domain_decomp_atm, only: dist_grid, getDomainBounds

implicit none

type (dist_grid), intent(in) :: grid
integer :: i_0, i_1, j_0, j_1
integer :: ier

call getDomainBounds(grid, i_strt=i_0, i_stop=i_1, j_strt=j_0, j_stop=j_1)

allocate(rn_src(i_0:i_1,j_0:j_1,12), stat=ier)

!-------------------------------------------------------------------------------
end subroutine alloc_radon_sources
!-------------------------------------------------------------------------------

!===============================================================================
end module tracers_radon_com
!===============================================================================
