#include "rundeck_opts.h"

!
! Defines a set of layering options and selects one
! via rundeck CPP symbol OCN_LAYERING
!

module olayers

  implicit none
  private

  public :: lmo,lmo_min,dZO

  integer :: iii ! iterator
  integer, parameter :: lmobig=100
  type layering_t
!@param lmo maximum number of ocean layers in a column
!@param lmo_min minimum number of ocean layers in a column
     integer :: lmo,lmo_min
!@param dZO  nominal thicknesses (m) of ocean layers
     real*8, dimension(lmobig) :: dZO
  end type layering_t

  ! L32
  ! L  dZO   ZOE   ZOC      L  dZO   ZOE   ZOC
  ! =  ===   ===   ===      =  ===   ===   ===
  ! 1   12    12     6     17  204  1900  1798
  ! 2   18    30    21     18  206  2100  2003
  ! 3   26    56    43     19  206  2312  2209
  ! 4   36    92    74     20  206  2518  2415
  ! 5   48   140   116     21  206  2724  2621
  ! 6   62   202   171     22  206  2930  2827
  ! 7   78   280   241     23  206  3136  3033
  ! 8   96   376   328     24  206  3342  3239
  ! 9  116   492   434     25  206  3548  3445
  !10  134   626   559     26  206  3754  3651
  !11  150   776   701     27  206  3960  3857
  !12  164   940   858     28  206  4166  4063
  !13  176  1116  1028     29  206  4372  4269
  !14  186  1302  1209     30  206  4578  4475
  !15  194  1496  1399     31  206  4784  4681
  !16  200  1696  1596     32  206  4990  4887
  type(layering_t), parameter, private :: L32 = layering_t( &
       lmo=32, &
       lmo_min=2, &
       dZO = (/ &
         12, 18, 26, 36,  48, 62, 78, 96, &
         116,134,150,164, 176,186,194,200, &
         204,206,206,206, 206,206,206,206, &
         206,206,206,206, 206,206,206,206 &
         , (0, iii=32+1,lmobig) /) &
         )

  type(layering_t), parameter, private :: L40_5008m = layering_t( &
       lmo=40, &
       lmo_min=2, &
       dZO = (/ &
         10,12,14,16, 18,20,20,20, &
         20,20,22,26, 32,40,50,62, &
         76,92,110,130, 148,166,180,192, &
         202,210,216,220, 222,222,222,222, &
         222,222,222,222, 222,222,222,222 &
         , (0, iii=40+1,lmobig) /) &
         )

  ! L48_5030m
  ! L  dZO   ZOE   ZOC    L  dZO   ZOE   ZOC    L  dZO   ZOE   ZOC
  !==  ===  ====  ====   ==  ===  ====  ====   ==  ===  ====  ====
  ! 1   10    10     5   17   20   310   300   33  206  1880  1777
  ! 2   12    22    16   18   20   330   320   34  210  2090  1985
  ! 3   14    36    29   19   22   352   341   35  210  2300  2195
  ! 4   16    52    44   20   26   378   365   36  210  2510  2405
  ! 5   18    70    61   21   32   410   394   37  210  2720  2615
  ! 6   20    90    80   22   40   450   430   38  210  2930  2825
  ! 7   20   110   100   23   50   500   475   39  210  3140  3035
  ! 8   20   130   120   24   62   562   531   40  210  3350  3245
  ! 9   20   150   140   25   76   638   600   41  210  3560  3455
  !10   20   170   160   26   92   730   684   42  210  3770  3665
  !11   20   190   180   27  110   840   785   43  210  3980  3875
  !12   20   210   200   28  130   970   905   44  210  4190  4085
  !13   20   230   220   29  150  1120  1045   45  210  4400  4295
  !14   20   250   240   30  170  1290  1205   46  210  4610  4505
  !15   20   270   260   31  186  1476  1383   47  210  4820  4715
  !16   20   290   280   32  198  1674  1575   48  210  5030  4925

  type(layering_t), parameter, private :: L48_5030m = layering_t( &
       lmo=48, &
       lmo_min=2, &
       dZO = (/ &
         10,12,14,16, 18,20,20,20, &
         20,20,20,20, 20,20,20,20, &
         20,20,22,26, 32,40,50,62, &
         76,92,110,130, 150,170,186,198, &
         206,210,210,210, 210,210,210,210, &
         210,210,210,210, 210,210,210,210  &
         , (0, iii=48+1,lmobig) /) &
         )

  ! L48_5950m
  ! L  dZO   ZOE   ZOC    L  dZO   ZOE   ZOC    L  dZO   ZOE   ZOC
  !==  ===  ====  ====   ==  ===  ====  ====   ==  ===  ====  ====
  ! 1   10    10     5   17   20   310   300   33  230  1920  1805
  ! 2   12    22    16   18   20   330   320   34  250  2170  2045
  ! 3   14    36    29   19   22   352   341   35  270  2440  2305
  ! 4   16    52    44   20   26   378   365   36  270  2710  2575
  ! 5   18    70    61   21   32   410   394   37  270  2980  2845
  ! 6   20    90    80   22   40   450   430   38  270  3250  3115
  ! 7   20   110   100   23   50   500   475   39  270  3520  3385
  ! 8   20   130   120   24   62   562   531   40  270  3790  3655
  ! 9   20   150   140   25   76   638   600   41  270  4060  3925
  !10   20   170   160   26   92   730   684   42  270  4330  4195
  !11   20   190   180   27  110   840   785   43  270  4600  4465
  !12   20   210   200   28  130   970   905   44  270  4870  4735
  !13   20   230   220   29  150  1120  1045   45  270  5140  5005
  !14   20   250   240   30  170  1290  1205   46  270  5410  5275
  !15   20   270   260   31  190  1480  1385   47  270  5680  5545
  !16   20   290   280   32  210  1690  1585   48  270  5950  5815
  type(layering_t), parameter, private :: L48_5950m = layering_t( &
       lmo=48, &
       lmo_min=2, &
       dZO = (/ &
         10,12,14,16, 18,20,20,20, &
         20,20,20,20, 20,20,20,20, &
         20,20,22,26, 32,40,50,62, &
         76,92,110,130, 150,170,190,210, &
         230,250,270,270, 270,270,270,270, &
         270,270,270,270, 270,270,270,270 &
         , (0, iii=48+1,lmobig) /) &
         )

  ! L13
  ! L  dZO    ZE   ZOC      L  dZO    ZE   ZOC
  ! =  ===    ==   ===      =  ===    ==   ===
  ! 1   12    12     6      7  137   386   318
  ! 2   18    30    21      8  205   591   488
  ! 3   27    57    44      9  308   899   745
  ! 4   41    98    77     10  461  1360  1129
  ! 5   61   158   128     11  692  2052  1706
  ! 6   91   249   204     12 1038  3090  2571
  !                        13 1557  4647  3868
  type(layering_t), parameter, private :: L13 = layering_t( &
       lmo=13, &
       lmo_min=2, &
       dZO = (/ &
         12d0, 18d0, 27d0, 40.5d0, 60.75d0, 91.125d0,  &
         136.6875d0, 205.03125d0, 307.546875d0,  &
         461.3203125d0, 691.98046875d0,  &
         1037.970703125d0, 1556.9560546875d0  &
         , (0d0, iii=13+1,lmobig) /) &
       )

! Select layering using rundeck CPP symbol OCN_LAYERING
  type(layering_t), parameter :: layering = OCN_LAYERING

! Expose the components of the layering selection
  integer, parameter :: &
       lmo     = layering%lmo, &
       lmo_min = layering%lmo_min
  real*8, parameter :: dZO(1:lmo) = layering%dZO(1:lmo)

end module olayers
