LLF102.R     GISS Model E     Lat-Lon Atmosphere Model     2017/01/03

LLF102 is continuously updated with most recent physics, parameters, and input files
LLF = Lat-lon Fine resolution = 2.5 x 2 degree horizontal resolution
   102 = 102 smoothed vertical layers with standard hybrid coordinate, top at .002 mb
Atmospheric composition for year 2000
Ocean climatology prescribed from years 1996-2005, CMIP6
Uses turbulence scheme (no dry conv), grav.wave drag
Time steps: dynamics 3.75 min leap frog; physics 30 min.; radiation 2.5 hrs
Filters: U,V in E-W and N-S direction (after every physics time step)
         U,V in E-W direction near poles (after every dynamics time step)
         sea level pressure (after every physics time step)

!! delete lines starting with '!!' unless E4F40 prepares a Q-flux ocean run
!! E4F40 is for NIsurf=1 (U00a=0.72; U00b=1.68)
!! E4qsF40.R GISS Model E  1850 atm, ocn: q-flux 65m             rar 07/15/2009
!! E4qsF40 = E4F40 with 65m q-flux ocean


Preprocessor Options
#define STDHYB                  ! standard hybrid vertical coordinate
#define ATM_LAYERING L102smoothed  ! 102 smooth layers, top at .002 mb
#define NEW_IO                  ! new I/O (netcdf) on
#define IRRIGATION_ON
#define NEW_BCdalbsn
#define ALT_MC_EXITS
#define SPECIFY_MU_SCALE
#define TAPER_UTCF
End Preprocessor Options


Object modules:
     ! resolution-specific source codes
Atm144x90                       ! horizontal resolution is 144x90 -> 2x2.5deg
AtmLayering                     ! vertical resolution
DIAG_RES_F                      ! diagnostics
FFT144                          ! Fast Fourier Transform
IO_DRV                          ! new i/o

     ! GISS dynamics with gravity wave drag
ATMDYN  MOMEN2ND                ! atmospheric dynamics
QUS_DRV  QUS3D                  ! advection of Q/tracers
STRATDYN  STRAT_DIAG            ! stratospheric dynamics (incl. gw drag)

#include "latlon_source_files"
#include "modelE4_source_files"
#include "static_ocn_source_files"


Components:
#include "E4_components_nc"    /* without "Ent" */
Ent


Component Options:
OPTS_Ent = ONLINE=YES PS_MODEL=FBB PFT_MODEL=ENT /* needed for "Ent" only */
OPTS_dd2d = NC_IO=PNETCDF


Data input files:
#include "IC_144x90_input_files"
#include "static_ocn_2000_144x90_input_files"

RVR=RD_Fb.nc             ! river direction file
NAMERVR=RD_Fb.names.txt  ! named river outlets

#include "land144x90_input_files"
#include "rad_input_files"
#include "rad_144x90_input_files_CMIP6clim"

MSU_wts=MSU_SSU_RSS_weights.txt      ! MSU-diag
REG=REG2X2.5                      ! special regions-diag


Label and Namelist:  (next 2 lines)
LLF102 is continuously updated with most recent physics, parameters, and input files
Year=2000, Ocean=CMIP6, Ent veg, gravity wave drag


&&PARAMETERS
#include "static_ocn_params"
#include "condensationF96_params"
#include "sdragF102_params"
#include "gwdragF102_params"

! cond_scheme=2     ! newer conductance scheme (N. Kiang) ! not used with Ent

! The following two lines are only used when aerosol/radiation interactions are off
FS8OPX = 1.,1.,1.,1.,1.5,1.5,1.,1.
FT8OPX = 1.,1.,1.,1.,1.,1.,1.,1.

PTLISO = 0.         ! pressure(mb) above which radiation assumes isothermal layers
H2ObyCH4 = 1.       ! activates stratospheric H2O generated by CH4
KSOLAR = 2          ! 2: use long annual mean file ; 1: use short monthly file

#include "atmCompos_2000_params"
madaer = 3          ! 3: updated aerosols ; 1: default sulfates/aerosols

DTsrc = 1800.       ! cannot be changed after a run has been started
DT    =  225.     
! parameters that control the Shapiro filter
DT_XUfilter = 225.  ! Shapiro filter on U in E-W direction; usually same as DT
DT_XVfilter = 225.  ! Shapiro filter on V in E-W direction; usually same as DT
DT_YVfilter = 0.    ! Shapiro filter on V in N-S direction
DT_YUfilter = 0.    ! Shapiro filter on U in N-S direction

NIsurf = 2          ! surface interaction computed NIsurf times per source time step
NRAD = 5            ! radiation computed NRAD times per source time step
#include "diag_params"

Nssw = 2            ! until diurnal diags are fixed, Nssw has to be even
NDISK = 960         ! write fort.1.nc or fort.2.nc every NDISK source time step        
&&END_PARAMETERS


 &INPUTZ
 IRANDI=0,
 YEARI=1997, MONTHI=12, DATEI=1, HOURI=0, ! pick IYEAR1=YEARI (default) or < YEARI
 YEARE=2010, MONTHE=01, DATEE=1, HOURE=0,   KDIAG=12*0,9,
 ISTART=2, YEARE=1997, MONTHE=12, DATEE=1, HOURE=1,
!! suggested settings for E4qsF40:
!! YEARI=1901,MONTHI=1,DATEI=1,HOURI=0,
!! YEARE=1931,MONTHE=1,DATEE=1,HOURE=0,   KDIAG=12*0,9,
!! ISTART=8,IRANDI=0, YEARE=1901,MONTHE=1,DATEE=1,HOURE=1,
/
