E4hyc00.R GISS Model E  coupled version          tnl   08/09/2010

E4hyc00: E4F40 coupled to 1x1deg 26-layer Hybrid-Isopycnal Coordinate Ocean Model (HYCOM)
Attempt increase planetary albedo:
U00A=.54 + U00B=1.0 + WMUI_multiplier=2 

E4hyc00 : sibling E113F40oQ32.R  
modelE1 (3.0) 2x2.5 hor. grid with 40 lyrs, top at .1 mb (+ 3 rad.lyrs)
atmospheric composition from year 1850
ocean: coupled to 1x1deg 26-layer HYCOM
uses turbulence scheme (no dry conv), grav.wave drag
time steps: dynamics 3.75 min leap frog; physics 30 min.; radiation 2.5 hrs
filters: U,V in E-W and N-S direction (after every physics time step)
         U,V in E-W direction near poles (after every dynamics time step)
         sea level pressure (after every physics time step)

Preprocessor Options
!#define TRACERS_ON                  ! include tracers code
#define CHECK_OCEAN                  ! needed to compile aux/file CMPE002
! #define TRACERS_GASEXCH_Natassa    ! special tracers to be passed to ocean
! #define TRACERS_HYCOM_Ventilation
#define ATM2x2h                      ! 2x2.5 40 layer atm
! #define ATM4x5                     ! 4x5 20 layer atm
#define HYCOM1deg                    ! 1deg 26 layer hycom (387x360x26)
! #define HYCOM2deg                  ! 2deg 26 layer hycom (195x180x26)
End Preprocessor Options

Object modules:
     ! resolution-specific source codes
Atm144x90                  ! horizontal resolution is 144x90 -> 2x2.5deg
AtmL40                      ! vertical resolution is 40 layers -> 0.1mb
DIAG_RES_F                          ! diagnostics
FFT144                              ! Fast Fourier Transform

IORSF                               ! old i/o

     ! GISS dynamics with gravity wave drag
ATMDYN MOMEN2ND                     ! atmospheric dynamics
QUS_DRV  QUS3D                      ! advection of Q/tracers
STRATDYN STRAT_DIAG                 ! stratospheric dynamics (incl. gw drag)

#include "latlon_source_files"
#include "modelE4_source_files"
#include "hycom_source_files"

Components:
#include "E4_components"    /* without "Ent" */
Ent

Component Options:
OPTS_Ent = ONLINE=YES PS_MODEL=FBB PFT_MODEL=ENT /* needed for "Ent" only */

Data input files:
#include "IC_144x90_input_files"
#include "hycom_387x360_input_files"

RVR=RD_modelE_Fa_1deghycom_may10.nc            ! river direction file
NAMERVR=RD_modelE_Fa_1deghycom_may10.names.txt ! named river outlets

#include "land144x90_input_files"
#include "rad_input_files"
#include "rad_144x90_input_files"

MSU_wts=MSU_SSU_RSS_weights.txt      ! MSU-diag
REG=REG2X2.5                      ! special regions-diag

Label and Namelist:  (next 2 lines)
E4hyc00 (2x2.5x40, 1850 atm.;  1x1x26 HYCOM ocean)


&&PARAMETERS
#include "dynamic_ocn_params"

#include "sdragF40_params"
#include "gwdragF40_params"

! cond_scheme=2   ! newer conductance scheme (N. Kiang) ! not used with Ent

! Increasing U00a decreases the high cloud cover; increasing U00b decreases net rad at TOA
U00a=.54   ! above 850mb w/o MC region;  tune this first to get 30-35% high clouds
U00b=1.0   ! below 850mb and MC regions; tune this last  to get rad.balance
WMUI_multiplier=2.

PTLISO=15.       ! press(mb) above which rad. assumes isothermal layers
H2ObyCH4=1.      ! activates strat.H2O generated by CH4
KSOLAR=2         ! 2: use long annual mean file ; 1: use short monthly file

#include "atmCompos_1850_params"
madaer=3         ! 3: updated aerosols          ; 1: default sulfates/aerosols

DTsrc=1800.      ! cannot be changed after a run has been started
DT=225.
! parameters that control the Shapiro filter
DT_XUfilter=225. ! Shapiro filter on U in E-W direction; usually same as DT
DT_XVfilter=225. ! Shapiro filter on V in E-W direction; usually same as DT
DT_YVfilter=0.   ! Shapiro filter on V in N-S direction
DT_YUfilter=0.   ! Shapiro filter on U in N-S direction

NIsurf=2         ! (surf.interaction NIsurf times per physics time step)
NRAD=5           ! radiation (every NRAD'th physics time step)

#include "diag_params"

itest=-1         ! default is -1
jtest=-1         ! default is -1
iocnmx=2         ! default is 2
brntop=50.       ! default is 50.
brnbot=200.      ! default is 200.
diapyn=2.e-7     ! default is 2.e-7
diapyc=.2e-4     ! default is .2e-4
jerlv0=1         ! default is 1

Nssw=48          ! until diurnal diags are fixed, Nssw has to be even
Ndisk=480
&&END_PARAMETERS

 &INPUTZ
 YEARI=1899,MONTHI=12,DATEI=01,HOURI=00, ! pick IYEAR1=YEARI (default) or < YEARI
 YEARE=1900,MONTHE=12,DATEE=02,HOURE=00, KDIAG=13*0,
 ISTART=2,IRANDI=0, YEARE=1899,MONTHE=12,DATEE=02,HOURE=00,IWRITE=1,JWRITE=1,
/
