#include "hycom_mpi_hacks.h"
      subroutine icexport(loan_ice)

! --- move ice equatorward to give it a chance to melt, thereby preventing
! --- excessive multiyear buildup of 'loan ice' generated by enloan.
! --- ice moves 1 grid point per stime step.

      USE DOMAIN_DECOMP_1D, only : AM_I_ROOT,HALO_UPDATE,NORTH,SOUTH,
     .                             GLOBALSUM
      USE HYCOM_DIM
      USE HYCOM_ARRAYS, only: idrift,jdrift,scp2,scp2i

      implicit none
      real,intent(INOUT) :: loan_ice(idm,J_0H:J_1H)
      real xcess(idm,J_0H:J_1H),tot1j(J_0:J_1),bfor1,aftr1,
     .     tot2j(J_0:J_1),bfor2,aftr2
      integer i,j,l,ia,ib,ja,jb
      real,parameter :: cutoff=1.e5				! W/m^2

      do 1 j=J_0,J_1
      tot1j(j)=0.
      tot2j(j)=0.
      do 1 l=1,isp(j)
      do 1 i=ifp(j,l),ilp(j,l)
      tot1j(j)=tot1j(j)+loan_ice(i,j)
! --- allow loan amounts > cutoff to stay where they are
      xcess(i,j)=(loan_ice(i,j)-min(loan_ice(i,j),cutoff*scp2(i,j)))
     .   *.1					! spread ice drift over time
      tot2j(j)=tot2j(j)+xcess(i,j)
 1    loan_ice(i,j)=loan_ice(i,j)-xcess(i,j)

cdiag CALL GLOBALSUM(ogrid,tot1j,bfor1, all=.true.)	! diagnostic use only
cdiag CALL GLOBALSUM(ogrid,tot2j,bfor2, all=.true.)	! diagnostic use only
      CALL HALO_UPDATE(ogrid,xcess, FROM=NORTH+SOUTH)

!$OMP PARALLEL DO PRIVATE(ia,ib,ja,jb)
      do 2 j=J_0,J_1
      ja = PERIODIC_INDEX(j-1, jj)
      jb = PERIODIC_INDEX(j+1, jj)
      tot1j(j)=0.
      tot2j(j)=0.
      do 2 l=1,isp(j)
      do 2 i=ifp(j,l),ilp(j,l)
      ia=max(  1,i-1)
      ib=min(ii1,i+1)
      if (idrift(ia,j).eq.i .and. jdrift(ia,j).eq.j) then
        loan_ice(i,j)=loan_ice(i,j)+xcess(ia,j)
        tot2j(j)=tot2j(j)+xcess(ia,j)
      end if
      if (idrift(ib,j).eq.i .and. jdrift(ib,j).eq.j) then
        loan_ice(i,j)=loan_ice(i,j)+xcess(ib,j)
        tot2j(j)=tot2j(j)+xcess(ib,j)
      end if
      if (idrift(i,ja).eq.i .and. jdrift(i,ja).eq.j) then
        loan_ice(i,j)=loan_ice(i,j)+xcess(i,ja)
        tot2j(j)=tot2j(j)+xcess(i,ja)
      end if
      if (idrift(i,jb).eq.i .and. jdrift(i,jb).eq.j) then
        loan_ice(i,j)=loan_ice(i,j)+xcess(i,jb)
        tot2j(j)=tot2j(j)+xcess(i,jb)
      end if
      tot1j(j)=tot1j(j)+loan_ice(i,j)
 2    continue
!$OMP END PARALLEL DO

cdiag CALL GLOBALSUM(ogrid,tot1j,aftr1, all=.true.)	! diagnostic use only
cdiag CALL GLOBALSUM(ogrid,tot2j,aftr2, all=.true.)	! diagnostic use only
cdiag if (AM_I_ROOT())
cdiag.  write(*,'(a,2es17.10,2es12.4)') 'icexport consv:',bfor1,aftr1,
cdiag.  bfor2,aftr2

      return
      end subroutine icexport


      subroutine export_init

! --- design routing scheme for equatorward ice export, to be used
! --- to prevent excessive multiyear ice buildup

      USE HYCOM_DIM
      USE HYCOM_ARRAYS, only: idrift,jdrift		! ice drift direction
      USE DOMAIN_DECOMP_1D, only: AM_I_ROOT,HALO_UPDATE,NORTH,SOUTH
      USE DOMAIN_DECOMP_1D, only: PACK_DATA
      USE DOMAIN_DECOMP_1D, only: GLOBALSUM
      USE  hycom_arrays_glob, only: idrift_glob => idrift,
     +                              jdrift_glob => jdrift

      implicit none
      integer test(idm,J_0H:J_1H),eqdist(idm,J_0H:J_1H),
     .        tmp(idm,J_0H:J_1H)
      real eventj(J_0:J_1),event,testr(idm,J_0H:J_1H),bfor,aftr,
     .     sumj(J_0:J_1)
      integer,allocatable :: globl(:,:)
      integer :: i,j,ia,ib,ja,jb,l,n,mindis,iter
      integer,parameter :: land=22222, undef=11111
      integer,parameter :: iequat=ii*3/5	! approx.location of equator

      if (AM_I_ROOT()) then
       allocate (globl(idm,jdm))
      else
       allocate (globl(1,1))
      end if

      idrift(:,:)=land
      jdrift(:,:)=land
      eqdist(:,:)=undef

      if (AM_I_ROOT())
     .  print *,'(export_init) initializing equator points, i=',iequat
      do j=J_0,J_1
       do l=1,isp(j)
        do i=ifp(j,l),ilp(j,l)
         idrift(i,j)=0
         jdrift(i,j)=0
         if (i.eq.iequat) eqdist(i,j)=1
        end do
       end do
      end do

! --- determine travel distance to equator
      do iter=1,1000
       if (AM_I_ROOT())
     . print *,'equatorial distance calculation, iter =',iter
       CALL HALO_UPDATE(ogrid,eqdist, FROM=NORTH+SOUTH)
!$OMP PARALLEL DO PRIVATE(ia,ib,ja,jb)
       do 1 j=J_0,J_1
       ja = PERIODIC_INDEX(j-1, jj)
       jb = PERIODIC_INDEX(j+1, jj)
       eventj(j)=0.
       do 1 l=1,isp(j)
       do 1 i=ifp(j,l),ilp(j,l)
       ia=max(  1,i-1)
       ib=min(ii1,i+1)
       tmp(i,j)=eqdist(i,j)
       mindis=min(eqdist(i,ja),eqdist(i,jb),eqdist(ia,j),eqdist(ib,j))
       if (eqdist(i,j).eq.undef .and. mindis.lt.undef) then
        tmp(i,j)=mindis+1
        eventj(j)=1.
       end if
 1     continue
!$OMP END PARALLEL DO
       call GLOBALSUM(ogrid,eventj,event, all=.true.)
       if (event.eq.0.) exit

!$OMP PARALLEL DO
       do 2 j=J_0,J_1
       do 2 l=1,isp(j)
       do 2 i=ifp(j,l),ilp(j,l)
 2     eqdist(i,j)=tmp(i,j)
!$OMP END PARALLEL DO
      end do			! iter

      call pack_data(ogrid, eqdist, globl)
      if (AM_I_ROOT()) call prifld(globl,idm,ii,jj,'eqdist')

! --- (idrift,jdrift) identifies the cell which (i,j)  d r a i n s   i n t o

      CALL HALO_UPDATE(ogrid,eqdist, FROM=NORTH+SOUTH)
!$OMP PARALLEL DO PRIVATE(ia,ib,ja,jb)
      do 3 j=J_0,J_1
      ja = PERIODIC_INDEX(j-1, jj)
      jb = PERIODIC_INDEX(j+1, jj)
      do 3 l=1,isp(j)
      do 3 i=ifp(j,l),ilp(j,l)
      ia=max(  1,i-1)
      ib=min(ii1,i+1)
! --- find neighboring cell that's closest to equator
      mindis=min(eqdist(i,ja),eqdist(i,jb),eqdist(ia,j),eqdist(ib,j))
      if      (eqdist(ia,j).eq.mindis) then
       idrift(i,j)=ia
       jdrift(i,j)=j
      else if (eqdist(ib,j).eq.mindis) then
       idrift(i,j)=ib
       jdrift(i,j)=j
      else if (eqdist(i,ja).eq.mindis) then
       idrift(i,j)=i
       jdrift(i,j)=mod(j-2+jj,jj)+1
      else if (eqdist(i,jb).eq.mindis) then
       idrift(i,j)=i
       jdrift(i,j)=mod(j     ,jj)+1
      end if
 3    continue
!$OMP END PARALLEL DO
      CALL HALO_UPDATE(ogrid,idrift, FROM=NORTH+SOUTH)
      CALL HALO_UPDATE(ogrid,jdrift, FROM=NORTH+SOUTH)

      call pack_data(ogrid, idrift, globl)
      if (AM_I_ROOT()) call prifld(globl,idm,ii,jj,'idrift')
      call pack_data(ogrid, jdrift, globl)
      if (AM_I_ROOT()) call prifld(globl,idm,ii,jj,'jdrift')

      call pack_data(ogrid, idrift, idrift_glob)
      call pack_data(ogrid, jdrift, jdrift_glob)

      GO TO 111    ! only for testing
c - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
! --- optional: test ice export
      test(:,:)=land
!$OMP PARALLEL DO
      do 6 j=J_0,J_1
      sumj(j)=0.
      do 6 l=1,isp(j)
      do 6 i=ifp(j,l),ilp(j,l)
      test(i,j)=0
      if (i.lt.ii/3 .or. i.gt.ii*2/3) then
       testr(i,j)=1.
       sumj(j)=sumj(j)+testr(i,j)
      else
       testr(i,j)=0.
      end if
      if (i.eq.178 .and. j.eq.13) test(i,j)=888		! blob near venice
      if (i.eq.183 .and. j.eq. 4) test(i,j)=777		! blob near barcelona
      if (i.eq.194 .and. j.eq.15) test(i,j)=666		! blob near tripoli
 6    continue
!$OMP END PARALLEL DO
      call GLOBALSUM(ogrid,sumj,bfor, all=.true.)

      call pack_data(ogrid, test, globl)
      if (AM_I_ROOT()) then
       print *,'export test, iter=',0
       call prifld(globl(176,342),idm,23,19,'export_test')
       call prifld(globl(176,  1),idm,23,19,'export_test')
      end if

      do n=1,50			! follow blobs for 50 steps
       CALL HALO_UPDATE(ogrid,test, FROM=NORTH+SOUTH)
       CALL HALO_UPDATE(ogrid,testr,FROM=NORTH+SOUTH)

!$OMP PARALLEL DO PRIVATE(ia,ib,ja,jb)
       do 4 j=J_0,J_1
       ja = PERIODIC_INDEX(j-1, jj)
       jb = PERIODIC_INDEX(j+1, jj)
       sumj(j)=0.
       do 4 l=1,isp(j)
       do 4 i=ifp(j,l),ilp(j,l)
       ia=max(  1,i-1)
       ib=min(ii1,i+1)
       if (idrift(i,j).eq.i .and. jdrift(i,j).eq.j) then
        print '(a,2i5,a)','(icexport) ERROR: point i,j=',i,j,
     .   ' is mapped onto itself'
        stop '(icexport_init error)'
       end if
       tmp(i,j)=0
       if (idrift(ia,j).eq.i .and. jdrift(ia,j).eq.j) then
        tmp(i,j)=tmp(i,j)+test(ia,j)
        sumj(j)=sumj(j)+testr(ia,j)
       end if
       if (idrift(ib,j).eq.i .and. jdrift(ib,j).eq.j) then
        tmp(i,j)=tmp(i,j)+test(ib,j)
        sumj(j)=sumj(j)+testr(ib,j)
       end if
       if (idrift(i,ja).eq.i .and. jdrift(i,ja).eq.j) then
        tmp(i,j)=tmp(i,j)+test(i,ja)
        sumj(j)=sumj(j)+testr(i,ja)
       end if
       if (idrift(i,jb).eq.i .and. jdrift(i,jb).eq.j) then
        tmp(i,j)=tmp(i,j)+test(i,jb)
        sumj(j)=sumj(j)+testr(i,jb)
       end if
 4     continue
!$OMP END PARALLEL DO
       call GLOBALSUM(ogrid,sumj,aftr, all=.true.)

!$OMP PARALLEL DO
       do 5 j=J_0,J_1
       do 5 l=1,isp(j)
       do 5 i=ifp(j,l),ilp(j,l)
 5     test(i,j)=tmp(i,j)
!$OMP END PARALLEL DO

       call pack_data(ogrid, test, globl)
       if (AM_I_ROOT()) then
        print *,'export test, iter=',n
        print '(a,2es17.9,es11.3)','conservation:',bfor,aftr,aftr-bfor
        call prifld(globl(176,342),idm,23,19,'export_test')
        call prifld(globl(176,  1),idm,23,19,'export_test')
       end if
      end do			! iter
c - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
111   CONTINUE
      return
      end subroutine export_init
