
ifneq ($(MODELE_CPATH),)
ifneq ($(CPATH),)
  CPATH_HACK = CPATH=$(strip $(MODELE_CPATH)):$(CPATH)
else
  CPATH_HACK = CPATH=$(strip $(MODELE_CPATH))
endif
endif

ifneq ($(MODELE_LIBRARY_PATH),)
ifneq ($(LIBRARY_PATH),)
  LIBRARY_PATH_HACK = LIBRARY_PATH=$(strip $(MODELE_LIBRARY_PATH)):$(LIBRARY_PATH)
else
  LIBRARY_PATH_HACK = LIBRARY_PATH=$(strip $(MODELE_LIBRARY_PATH))
endif
endif

# LIBRARY_PATH is specified for F90 because it is used for linking
F90 = $(LIBRARY_PATH_HACK) flang
CC = $(CPATH_HACK) clang
ifneq ($(CPATH_HACK),)
  CPP := $(CPATH_HACK) $(CPP)
endif
FLANG_RELEASE := $(shell flang --version | perl -e '<>=~/ (\d+)/; print "$$1";')
$(warning COMPILER: flang RELEASE: $(FLANG_RELEASE))
$(warning Warning: Support for flang is experimental)
ifneq ($(shell if [ $(FLANG_RELEASE) -lt 22 ] ; then echo "not okey" ; fi),)
  $(error Your flang version is too old: $(FLANG_RELEASE). Use >=22)
endif

FMAKEDEP = $(SCRIPTS_DIR)/sfmakedepend
CPPFLAGS += -DCOMPILER_FLANG
FFLAGS = -g -cpp -fconvert=big-endian -O2 -fwrapv
F90FLAGS = -g -cpp -fconvert=big-endian -O2 -fwrapv -ffree-form
LFLAGS =

# option to treat default real as real*8
R8 = -fdefault-real-8 -fdefault-double-8
I4 = 
#I4 = -fdefault-integer-4
EXTENDED_SOURCE = -ffixed-line-length-132
#CRAYPTRFLAGS = -fcray-pointer

#
# Set the following to ensure that the beginning/end of records
# in sequential-access unformatted files have 4-byte markers
# (this does impose a 2 GB limit on record sizes, however)
#
#FFLAGS += -frecord-marker=4
#F90FLAGS += -frecord-marker=4

# check if ABI was specified explicitly
# (looks like this flag is not accepted by flang)
M64 =
ifneq ($(ABI),)
# leave it unset for arm64 Linux
ifneq ($(IS_AARCH64),YES)
#  M64 = -m$(ABI)
endif
endif

FFLAGS += $(M64)
F90FLAGS += $(M64)
LFLAGS += $(M64)

# flags needed for particular releases

FFLAGS_RELEASE =
# not sure if this is needed for flang - check
#ifneq (,$(filter 22,$(FLANG_RELEASE)))
#FFLAGS_RELEASE += -fno-expensive-optimizations
#endif

FFLAGS += $(FFLAGS_RELEASE)
F90FLAGS += $(FFLAGS_RELEASE)

# these have not been checked yet
# the following switch adds extra debugging
ifeq ($(COMPILE_WITH_TRAPS),YES)
$(warning TRAPS have not been tested with flang yet)
FFLAGS += -fbounds-check -ffpe-trap=invalid,zero,overflow -fbacktrace
F90FLAGS += -fbounds-check -ffpe-trap=invalid,zero,overflow -fbacktrace
FFLAGS += -finit-real=snan
F90FLAGS += -finit-real=snan
#LFLAGS += -lefence
endif
